importScripts("i18n-helper.js"),importScripts("queue.js"),importScripts("tab_manager.js"),importScripts("compression.js"),importScripts("pako.min.js");let identify="",version="",searchWindowId=null;
// 安全的消息发送函数，避免popup关闭时的连接错误
function safeSendMessage(message,callback){try{chrome.runtime.sendMessage(message,function(response){chrome.runtime.lastError||callback&&callback(response)})}catch(error){}}
//=============could be deleted==============
// 创建一个返回Promise的安全消息发送函数
function safeSendMessagePromise(message){return new Promise(resolve=>{try{chrome.runtime.sendMessage(message,function(response){chrome.runtime.lastError?resolve(null):resolve(response)})}catch(error){resolve(null)}})}
// 历史记录管理函数
let HistoryManager={
// 添加操作历史记录
addHistory:function(operation,isAuto=!1){let now=new Date;let historyItem=now.getMonth()+1+`-${now.getDate()} ${now.getHours().toString().padStart(2,"0")}:${now.getMinutes().toString().padStart(2,"0")}:`+now.getSeconds().toString().padStart(2,"0")+" "+(isAuto?"自动 ":"手动 ")+operation;chrome.storage.local.get(["opt-history"],function(result){let history=result["opt-history"]||[];history.unshift(historyItem),// 添加到数组开头
// 限制历史记录数量，保留最近50条
50<history.length&&(history=history.slice(0,50)),chrome.storage.local.set({"opt-history":history},function(){chrome.storage.local.set({lastUploadTime:Date.now()},function(){})})})},
// 获取操作历史记录
getHistory:function(callback){chrome.storage.local.get(["opt-history"],function(result){result=result["opt-history"]||[];callback(result)})},
// 清除操作历史记录
clearHistory:function(){chrome.storage.local.set({"opt-history":[]},function(){})}},messageQueue=new MessageQueue;
// 完整使用示例
// 创建消息队列实例
//=============could be deleted==============
function toggleFeature(){chrome.storage.local.set({search:"1"},function(data){createSearchWindow()})}
//=============could be deleted==============
function createSearchWindow(){
// 如果搜索窗口已经存在，就关闭它
null!==searchWindowId?chrome.windows.remove(searchWindowId,function(){chrome.runtime.lastError,searchWindowId=null}):chrome.windows.getAll({windowTypes:["normal"]},function(windows){var windows=windows[0],left=Math.max(0,Math.round(windows.left+(windows.width-700)/2)),windows=Math.max(0,Math.round(windows.top+(windows.height-300)/2)),searchUrl=chrome.runtime.getURL("search.html");chrome.windows.create({url:searchUrl,focused:!0,width:700,height:300,type:"panel",left:left,top:windows},function(createdWindow){if(!chrome.runtime.lastError){searchWindowId=createdWindow.id;let focusListener=function(windowId){windowId!==chrome.windows.WINDOW_ID_NONE&&windowId!==searchWindowId&&null!==searchWindowId&&(chrome.windows.onFocusChanged.removeListener(focusListener),chrome.windows.remove(searchWindowId,function(){chrome.runtime.lastError,searchWindowId=null}))};chrome.windows.onFocusChanged.addListener(focusListener),chrome.windows.onRemoved.addListener(function(windowId){windowId===searchWindowId&&(searchWindowId=null)})}})})}
// 单独的函数用于安排下一次任务执行
function scheduleAlarm(){chrome.storage.local.get(["syncInterval"],function(result){
// 如果result.syncInterval 存在且为数字
result.syncInterval&&!isNaN(result.syncInterval)&&(interval=result.syncInterval,
// 检查是否已存在同名告警
chrome.alarms.get("keep-alive",function(existingAlarm){if(existingAlarm)
// 如果告警已存在，计算剩余时间
{var now=new Date;existingAlarm.scheduledTime,now.getTime()}else{
// 没有现有告警，创建新的
let now=new Date;new Date(now.getTime()+6e4*interval);// 转换为毫秒
//                console.log(`scheduleAlarm: 创建新的告警，下次执行时间: ${nextAlarmTime.toISOString()}, ${interval}分钟后`);
chrome.alarms.create("keep-alive",{periodInMinutes:Number(interval)}),
// 获取并显示当前告警信息
chrome.alarms.get("keep-alive",function(alarm){alarm&&new Date(alarm.scheduledTime)})}}))})}function performTask(){
// 检查全局同步锁，防止并发执行，添加超时机制
chrome.storage.local.get(["globalSyncLock"],function(result){
// 检查锁是否超时（超过5分钟）
if(result.globalSyncLock){result=parseInt(result.globalSyncLock);if(isNaN(result)||!(3e5<Date.now()-result))return;chrome.storage.local.remove("globalSyncLock")}let browser="";chrome.storage.local.get(["defaultBrowser","identify","autoSync","BASE_URL"],function(result){let item=result.identify;""===item||null==item||(""!==(browser=result.defaultBrowser)&&null!=browser||(
// 任务完成后安排下一次执行
browser="Chrome",chrome.storage.local.set({defaultBrowser:"Chrome"})),result.autoSync)||(
// 执行本地重复书签检查
checkLocalDuplicateBookmarks(),
// 添加自动同步历史记录
HistoryManager.addHistory("同步",!0),
// 设置全局同步锁，存储当前时间戳
chrome.storage.local.set({globalSyncLock:Date.now().toString()},function(){
// 调用下载函数，不使用防抖版本以确保执行
download(browser,!1,item,result.BASE_URL).finally(()=>{
// 确保在任何情况下都释放全局同步锁
chrome.storage.local.remove("globalSyncLock"),chrome.storage.local.set({isDownloading:"0"})})}))})})}async function download(type,needShow,item,baseUrl){var lockResult=await new Promise(resolve=>{chrome.storage.local.get(["downloadLock"],function(result){resolve(result.downloadLock)})});
// 检查锁是否超时（超过5分钟）
if(lockResult){lockResult=parseInt(lockResult);if(isNaN(lockResult)||!(3e5<Date.now()-lockResult))return Promise.resolve();await new Promise(resolve=>{chrome.storage.local.remove("downloadLock",function(){resolve()})})}
// 设置下载锁，存储当前时间戳
await new Promise(resolve=>{chrome.storage.local.set({downloadLock:Date.now().toString()},function(){resolve()})});try{
// 通知popup显示进度条
safeSendMessage({action:"syncProgressUpdate",current:0,total:100,// 初始值，后续会被更新
percentage:0});let jsonRes=await sendXhrRequest("POST",baseUrl,{code:"1006",identify:item},null);if(!jsonRes.source.hasSafari&&!jsonRes.source.hasChrome)return Promise.resolve();
// 使用parseInt()将字符串转换为整数
let versionString;return new Promise(resolve=>{chrome.storage.local.get(["version"],function(res){versionString=res.version,versionInt=parseInt(versionString,10),isNaN(versionInt)&&(versionInt=0),jsonRes.version<=versionInt?(
// 即使是最新版本，也要发送完成消息，但不隐藏进度条
safeSendMessage({action:"syncProgressUpdate",current:0,total:0,percentage:100}),resolve()):chrome.storage.local.set({isDownloading:"1"},function(d){var isSafari=jsonRes.message.hasSafari&&!jsonRes.message.hasChrome||"Safari"===type;
// 直接传递 identify 值，而不是依赖全局变量
importBookmarksFromURL(baseUrl,item,isSafari?"Safari":"Chrome"),resolve()})})})}catch(error){
// 发生错误时，通知popup显示错误状态
safeSendMessage({action:"syncProgressUpdate",error:!0}),
// 确保在任何情况下都释放下载锁
await new Promise(resolve=>{chrome.storage.local.remove("downloadLock",function(){resolve()})})}}async function importBookmarksFromURL(url,identify,browser){try{
// 记录开始时间
Date.now();let syncOtherFolders=await new Promise(resolve=>{chrome.storage.local.get(["syncOtherFolders"],function(data){resolve(data.syncOtherFolders||!1)})});chrome.storage.local.get(["version","identify"],function(resultVersion){version=resultVersion.version,versionInt=parseInt(version,10),isNaN(versionInt)&&(version="0");resultVersion={identify:resultVersion.identify,code:"1002",tag:browser,version:version};Date.now();sendXhrRequest("GET",url,resultVersion,null).then(response=>{Date.now();try{let bookmarks=response.message;if(void 0===response.success||response.success){Date.now();chrome.storage.local.set({version:response.version}),chrome.bookmarks.getTree(function(bookmarkTreeNodes){
// 等待删除完成后再进行导入
new Promise(resolve=>{if(syncOtherFolders)deleteNode(bookmarkTreeNodes[0],function(){resolve()});else{let deletePromises=[];bookmarkTreeNodes.forEach(function(node){node.children&&node.children.forEach(function(folder){"1"!==folder.id&&"2"!==folder.id||// 删除书签栏 (id="1") 和其他书签文件夹 (id="2")
folder.children&&folder.children.forEach(function(child){deletePromises.push(new Promise(resolveDelete=>{chrome.bookmarks.removeTree(child.id,function(){chrome.runtime.lastError,resolveDelete()})}))})})}),Promise.all(deletePromises).then(()=>{resolve()})}}).then(()=>{
// 计算总的书签数量
let totalBookmarks=0;
// 定义进度回调函数
function progressCallback(current,total,percentage){
// 向popup发送进度更新
safeSendMessage({action:"syncProgressUpdate",current:current,total:total,percentage:percentage})}
// 递归计算节点总数
function countNodes(nodes){let count=0;return nodes.forEach(node=>{count++,node.children&&(count+=countNodes(node.children))}),count}
// 创建一个共享的已创建计数器
bookmarks[0].children.forEach(node=>{("Safari"!==browser||"BookmarksBar"!==node.title)&&"1"!==node.id&&"2"!==node.id||(totalBookmarks+=countNodes(node.children))});let createdCounter={count:0},importPromises=[];
// 处理每个顶级节点
bookmarks[0].children.forEach((node,index)=>{"Safari"===browser&&"BookmarksBar"===node.title||"1"===node.id?importPromises.push(addBookmarks(node.children,"1",progressCallback,totalBookmarks,createdCounter)):"2"===node.id&&syncOtherFolders&&importPromises.push(addBookmarks(node.children,"2",progressCallback,totalBookmarks,createdCounter))}),
// 等待所有导入完成
Promise.all(importPromises).then(function(results){Date.now();
// 计算总体结果
let total=0,success=0,error=0;results.forEach(result=>{total+=result.total,success+=result.success,error+=result.error}),
// 向popup发送完成消息，但不隐藏进度条
safeSendMessage({action:"syncProgressUpdate",current:total,total:total,percentage:100}),
// 显示下载成功的通知
showSyncSuccessNotification("download"),
// 设置下载完成状态
chrome.storage.local.set({isDownloading:"0"})}).catch(function(error){Date.now();
// 即使出错也设置下载完成状态
chrome.storage.local.set({isDownloading:"0"}),
// 向popup发送错误消息
safeSendMessage({action:"syncProgressUpdate",error:!0})})})})}}catch(e){Date.now();
// 即使出错也设置下载完成状态
chrome.storage.local.set({isDownloading:"0"})}}).catch(function(error){chrome.storage.local.set({isDownloading:"0"}),safeSendMessage({action:"syncProgressUpdate",error:!0})})})}catch(error){Date.now();
// 即使出错也设置下载完成状态
chrome.storage.local.set({isDownloading:"0"})}}function addBookmarks(nodes,parentId,progressCallback=null,totalNodesCount=null,createdCounter=null){
// 增加并发限制来提高性能，同时避免过多的并行操作
let index=0;// 从10增加到20
nodes.length;
// 如果没有提供已创建计数器，则创建一个新的
// 开始处理批次
return null===createdCounter&&(createdCounter={count:0}),
// 如果没有提供总节点数，则计算它
null===totalNodesCount&&(totalNodesCount=
// 递归计算总节点数（包括子节点）
function countTotalNodes(nodes){let count=0;return nodes.forEach(node=>{count++,node.children&&0<node.children.length&&(count+=countTotalNodes(node.children))}),count}(nodes)),0<nodes.length?function processBatch(){
// 收集当前批次的节点
for(var promises,batch=[];index<nodes.length&&batch.length<20;)batch.push(nodes[index]),index++;return 0===batch.length?Promise.resolve():(
// 等待当前批次完成
promises=batch.map(function(node){let newNode={parentId:parentId,title:node.title,url:node.url};return new Promise(function(resolve){node.url?
// 创建书签
chrome.bookmarks.create(newNode,function(result){
// 更新进度
var progress;chrome.runtime.lastError||
// 成功创建，更新计数器
createdCounter.count++,progressCallback&&(progress=Math.round(createdCounter.count/totalNodesCount*100),progressCallback(createdCounter.count,totalNodesCount,progress)),resolve()}):
// 创建书签文件夹
chrome.bookmarks.create(newNode,function(createdNode){chrome.runtime.lastError||
// 成功创建，更新计数器
createdCounter.count++,node.children&&0<node.children.length&&createdNode?
// 递归处理子节点，传递相同的计数器和总节点数
addBookmarks(node.children,createdNode.id,progressCallback,totalNodesCount,createdCounter).then(function(){resolve()}).catch(function(error){resolve()}):(
// 更新进度
progressCallback&&(createdNode=Math.round(createdCounter.count/totalNodesCount*100),progressCallback(createdCounter.count,totalNodesCount,createdNode)),resolve())})})}),Promise.all(promises).then(function(){
// 如果还有更多节点需要处理，继续处理下一批
if(index<nodes.length)
// 添加一个小延迟以避免阻塞UI
return new Promise(function(resolve){setTimeout(function(){processBatch().then(resolve)},10)})}));
// 并行处理当前批次的所有节点
}().then(function(){return{total:createdCounter.count,success:createdCounter.count,error:totalNodesCount-createdCounter.count}}):Promise.resolve({total:0,success:0,error:0})}async function sendXhrRequest(method,url,headers,body){
// 浏览器会自动处理Accept-Encoding头部，所以我们不需要手动设置
// 直接使用原始头部
return messageQueue.enqueue(body,{url:url,method:method,headers:headers})}function deleteNode(node,callback){if(node.children){let folderPromises=[];node.children.forEach(folder=>{if(("1"===folder.id||"2"===folder.id)&&folder.children){
// 批量删除书签以提高性能
let childrenIds=folder.children.map(child=>child.id),index=0;// 增加批处理大小以提高性能
folder=new Promise(resolve=>{
// 开始删除批次
!function deleteBatch(){let batch=childrenIds.slice(index,index+20);if(0===batch.length)resolve();else{let deletedCount=0,errorCount=0;batch.forEach(childId=>{try{chrome.bookmarks.removeTree(childId,function(){chrome.runtime.lastError?errorCount++:deletedCount++,
// 检查是否已完成当前批次的所有删除操作
deletedCount+errorCount===batch.length&&((index+=20)<childrenIds.length?
// 继续删除下一批
setTimeout(deleteBatch,10):
// 所有批次完成
resolve())})}catch(e){errorCount++,
// 检查是否已完成当前批次的所有删除操作
deletedCount+errorCount===batch.length&&((index+=20)<childrenIds.length?
// 继续删除下一批
setTimeout(deleteBatch,10):
// 所有批次完成
resolve())}})}}()});folderPromises.push(folder)}}),
// 等待所有文件夹删除完成
Promise.all(folderPromises).then(()=>{callback&&callback()}).catch(error=>{callback&&callback()})}else callback&&callback()}
// 书签事件监听器 - 统一处理所有书签变化事件
// 统一的书签事件处理函数
function handleBookmarkEvent(eventType,id,info){
// 检查是否正在下载、是否在重建或popup是否打开
chrome.storage.local.get(["isDownloading","popupOpen","autoSync","isRebuilding"],function(data){
// 如果正在下载，直接返回
"1"===data.isDownloading||!0===data.isRebuilding||"1"===data.popupOpen||void 0!==data.autoSync&&!data.autoSync||delay_upload(eventType)})}
// 声明防抖定时器变量
// 设置超时时间为60秒，以适应大文件上传/下载
messageQueue.setTimeout(6e4),
// 配置默认请求选项
messageQueue.setRequestOptions({url:"https://bk.ithuajiao.site",method:"POST",headers:{}}),
// 设置消息处理函数 - 发送HTTP请求
messageQueue.setHandler(async(message,options)=>{try{
// 对于大量数据，添加gzip支持
var headers={...options.headers},response=await fetch(options.url,{method:options.method,headers:headers,body:message});
// 注意：我们不手动设置Accept-Encoding头部，因为浏览器会自动处理
if(!response.ok)throw new Error("HTTP error! status: "+response.status);
// 尝试解析响应为JSON
let responseData;try{responseData=await response.json()}catch(parseError){
// 如果JSON解析失败，尝试获取文本内容
var textData=await response.text();
// 创建一个模拟的响应对象
responseData={success:!1,message:"响应不是有效的JSON格式",rawResponse:textData}}return responseData}catch(error){throw error;// 抛出错误让队列处理
}}),chrome.runtime.onMessage.addListener((message,sender,sendResponse)=>{if("no_autoSync"===message.event)
// 复选框未选中，表示启用自动同步
chrome.storage.local.set({autoSync:!1},function(){
// 启用自动同步，设置定时器
scheduleAlarm()});else if("yes_autoSync"===message.event)
// 复选框被选中，表示启用手动同步
chrome.storage.local.set({autoSync:!0},function(){chrome.alarms.clear("keep-alive")});else if("plugin_activated"===message.event)chrome.storage.local.get(["BASE_URL","identify"],function(result){identify=result.identify});else{if("get_history"===message.action)
// 获取历史记录
return HistoryManager.getHistory(function(history){sendResponse({success:!0,history:history})}),!0;// 保持消息通道开放以进行异步响应
{if("clear_history"===message.action)
// 清除历史记录
return HistoryManager.clearHistory(),sendResponse({success:!0}),!0;"updateTabConfig"===message.event?
// 更新标签页管理器的配置
"undefined"!=typeof tabManager?(tabManager.updateConfig({maxTabs:message.config.maxTabs,timeLimit:message.config.timeLimit}),sendResponse({success:!0})):sendResponse({success:!0,error:"标签页管理器未定义"}):"set_syncInterval"===message.event?(chrome.alarms.clear("keep-alive"),chrome.storage.local.set({syncInterval:message.data}),scheduleAlarm()):"set_url"===message.event&&(chrome.storage.local.set({BASE_URL:message.BASE_URL}),
// 检查然后设置默认同步时间
scheduleAlarm())}}}),chrome.runtime.onStartup.addListener(()=>{chrome.storage.local.get(["autoSync","defaultBrowser"],function(result){
// autoSync为true表示手动同步模式，false表示自动同步模式
""===result.autoSync||void 0===result.autoSync||result.autoSync?(chrome.alarms.clear("keep-alive"),chrome.storage.local.set({autoSync:!0})):scheduleAlarm(),
// 判断是否需要默认设置
""!==result.defaultBrowser&&void 0!==result.defaultBrowser||chrome.storage.local.set({defaultBrowser:"chrome"})}),
//=============could be deleted==============
chrome.alarms.create("keep-alive0",{periodInMinutes:Number(.3)})}),chrome.runtime.onConnect.addListener(port=>{"popup"===port.name&&(
//        console.log(`chrome.runtime.onConnect: popup连接, 时间: ${new Date().toISOString()}`);
chrome.storage.local.get(["autoSync"],function(autoSyncResult){!1===autoSyncResult.autoSync&&
// 获取当前告警信息
chrome.alarms.get("keep-alive",function(alarm){var now;alarm&&(new Date(alarm.scheduledTime),now=new Date,alarm.scheduledTime,now.getTime())})}),chrome.storage.local.set({popupOpen:"1"},function(data){
// popup打开时，不干扰定时器
}),port.onDisconnect.addListener(()=>{
//            console.log(`popup断开连接: ${new Date().toISOString()}`);
chrome.storage.local.set({popupOpen:"0"},function(data){
// popup关闭后，检查定时器状态
chrome.alarms.get("keep-alive",function(alarm){alarm||
// 如果定时器不存在（可能因为其他原因被清除），则重新创建
scheduleAlarm()})})}))}),chrome.alarms.onAlarm.addListener(alarm=>{"keep-alive"===alarm.name&&performTask()}),
// background.js
chrome.runtime.onInstalled.addListener(detail=>{"update"===detail.reason&&scheduleAlarm(),chrome.storage.local.get(["contextMenuEnabled"],function(result){}),chrome.storage.local.get("firstInstall",data=>{data.firstInstall||(chrome.tabs.create({url:"welcome.html"}),chrome.storage.local.set({firstInstall:!0}))}),chrome.storage.local.get("autoSync",data=>{null==data.autoSync&&chrome.storage.local.set({autoSync:!1})})}),
// 监听来自popup的消息
chrome.runtime.onMessage.addListener(function(message,sender,sendResponse){return"upload_bookmarks"===message.action?(
// 执行上传操作
performUpload(message.defaultBrowser),sendResponse({success:!0,message:"上传请求已接收"}),!0):"download_bookmarks"===message.action?(
// 执行下载操作
performDownload(message.defaultBrowser,message.needShow),sendResponse({success:!0,message:"下载请求已接收"}),!0):"delete_local_bookmarks"===message.action?(
// 执行删除本地书签操作
performDeleteLocalBookmarks(),sendResponse({success:!0,message:"删除本地书签请求已接收"}),!0):void 0}),chrome.commands.onCommand.addListener(command=>{"open-search"===command&&chrome.tabs.query({active:!0,currentWindow:!0},tabs=>{toggleFeature()})}),chrome.bookmarks.onMoved.addListener((id,bookmark)=>{handleBookmarkEvent("onMoved",id,bookmark)}),chrome.bookmarks.onCreated.addListener((id,bookmark)=>{handleBookmarkEvent("onCreated",id,bookmark)}),chrome.bookmarks.onRemoved.addListener((id,removeInfo)=>{handleBookmarkEvent("onRemoved",id,removeInfo)}),chrome.bookmarks.onChanged.addListener((id,changeInfo)=>{handleBookmarkEvent("onChanged",id,changeInfo)}),chrome.bookmarks.onChildrenReordered.addListener((id,reorderInfo)=>{handleBookmarkEvent("onChildrenReordered",id,reorderInfo)}),chrome.bookmarks.onImportEnded.addListener(()=>{handleBookmarkEvent("onImportEnded",null,null)});let uploadTimer=null,downloadDebounceTimer=null;
// 声明下载防抖定时器变量
// 过滤书签树，只保留书签栏中的书签
function filterBookmarksTree(bookmarkTree){var bookmarksBar;
// 查找书签栏节点（通常是第一个节点，id为"1"）
return bookmarkTree&&Array.isArray(bookmarkTree)&&(bookmarksBar=bookmarkTree.find(node=>"1"===node.id||"Bookmarks bar"===node.title||"书签栏"===node.title))?[bookmarksBar]:bookmarkTree}function delay_upload(eventType){clearTimeout(uploadTimer),// 清除之前的定时器
uploadTimer=setTimeout(function(){chrome.storage.local.get(["defaultBrowser","isDownloading","autoSync","popupOpen","isRebuilding"],function(data){
// 检查自动同步设置
void 0!==data.autoSync&&!data.autoSync||"1"===data.isDownloading||!0===data.isRebuilding||
// 检查popup是否打开
//            if (data.popupOpen === '1') {
//                console.log(`[DELAY_UPLOAD] popup打开中，取消上传`);
//                return;
//            }
// 获取用户信息
chrome.storage.local.get(["identify","sync_target","p"],function(data2){
// 检查 identify 值是否存在
data2.identify&&chrome.bookmarks.getTree(function(bookmarkTreeNodes){let bookmarks=JSON.stringify(bookmarkTreeNodes),browserType="chrome",headers=(void 0!==(browserType=void 0===data2.sync_target||""===data2.sync_target||null===data2.sync_target?data.defaultBrowser||"chrome":"0"===data2.sync_target?"safari":"chrome")&&""!==browserType&&null!==browserType||(browserType="chrome"),{"Content-Type":"application/json",identify:data2.identify,code:"1003",tag:browserType});
// 添加自动上传历史记录
HistoryManager.addHistory(`自动上传(${eventType})`,!0),chrome.storage.local.get(["BASE_URL"],function(result){
// 确保 BASE_URL 存在
result.BASE_URL||(result.BASE_URL="https://bk.ithuajiao.site");let uploadStartTime=Date.now();sendXhrRequest("POST",result.BASE_URL,headers,bookmarks).then(data=>{Date.now(),uploadStartTime;!data.success&&0<=data.message.indexOf("duplicate")?(
// 添加重复数据检测历史记录
HistoryManager.addHistory("手动上传检测到重复数据，重建本地书签",!1),
// 设置重建标志，防止删除时触发上传
chrome.storage.local.set({isRebuilding:!0},function(){
// 删除本地 重新拉取
deleteAll(function(){
// 清除重建标志
chrome.storage.local.remove("isRebuilding",function(){debouncedDownload("Chrome",!1,data2.identify,result.BASE_URL,1e3)})})})):(chrome.storage.local.set({isDownloading:"0"}),
// 显示上传成功的通知
showSyncSuccessNotification("upload"))}).catch(error=>{
// 确保在出错时也清除下载状态
chrome.storage.local.set({isDownloading:"0"})})})})});
// 再次检查是否正在下载
})},5e3)}
// 防抖包装函数，用于download函数
function debouncedDownload(type,needShow,item,baseUrl,delay=3e3){
// 创建并返回一个Promise
// 清除之前的定时器
return downloadDebounceTimer&&clearTimeout(downloadDebounceTimer),new Promise((resolve,reject)=>{
// 设置新的定时器
downloadDebounceTimer=setTimeout(()=>{download(type,needShow,item,baseUrl).then(resolve).catch(reject)},delay)})}
// 显示同步成功通知（上传或下载）
function showSyncSuccessNotification(type){
// 获取同步通知配置
chrome.storage.local.get(["uploadNotification"],function(data){
// 如果未开启同步通知，则直接返回
data.uploadNotification&&(data="upload"===type?"书签已成功上传到云端！":"书签已成功下载到本地！",
// 方法1: 使用chrome.notifications API
chrome.notifications.create({type:"basic",iconUrl:chrome.runtime.getURL("icons/icon48.png"),title:"书签同步",message:new Date(Date.now()).toISOString()+data,priority:2,requireInteraction:!0},function(notificationId){
// 5秒后自动清除通知
setTimeout(()=>{chrome.notifications.clear(notificationId,function(wasCleared){})},1e4)}))})}
//=============could be deleted==============
function deleteAll(callback){Date.now();chrome.storage.local.remove("version"),chrome.bookmarks.getTree(function(bookmarkTreeNodes){let deletePromises=[];bookmarkTreeNodes.forEach(node=>{deletePromises.push(new Promise(resolve=>{deleteNode(node,resolve)}))}),Promise.all(deletePromises).then(()=>{Date.now();callback&&callback()}).catch(error=>{callback&&callback()})})}
// 执行上传操作的函数
async function performUpload(defaultBrowser){var uploadStartTime=Date.now();try{
// 检查全局同步锁，防止并发执行，添加超时机制
var lockResult=await new Promise(resolve=>{chrome.storage.local.get(["globalSyncLock"],function(result){resolve(result.globalSyncLock)})});
// 检查锁是否超时（超过5分钟）
if(lockResult){let lockTime=parseInt(lockResult);if(isNaN(lockTime)||!(3e5<Date.now()-lockTime))return;await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}
// 设置全局同步锁，存储当前时间戳
let lockTime=Date.now().toString();await new Promise(resolve=>{chrome.storage.local.set({globalSyncLock:lockTime},function(){resolve()})}),
// 添加手动上传历史记录
HistoryManager.addHistory("手动上传",!1);
// 获取用户标识和基础URL
var result=await new Promise(resolve=>{chrome.storage.local.get(["identify","sync_target","BASE_URL"],function(data){resolve(data)})});if(result.identify){
// 获取书签数据
var bookmarkTreeNodes=await new Promise(resolve=>{chrome.bookmarks.getTree(function(nodes){resolve(nodes)})}),bookmarks=JSON.stringify(bookmarkTreeNodes);
// 决定上传的浏览器类型
let browserType="chrome";void 0!==(browserType=void 0===result.sync_target||""===result.sync_target||null===result.sync_target?defaultBrowser||"chrome":"0"===result.sync_target?"safari":"chrome")&&""!==browserType&&null!==browserType||(browserType="chrome");
// 获取压缩后的数据和头部信息
var compressedData=CompressionUtils.getCompressedData(bookmarks),headers={"Content-Type":"application/json",identify:result.identify,code:"1003",tag:browserType,...compressedData.headers},responseText=(Date.now(),await sendXhrRequest("POST",result.BASE_URL,headers,compressedData.data));Date.now();let resultJson;try{
// 检查responseText是否已经是解析后的对象
resultJson="string"==typeof responseText?JSON.parse(responseText):responseText}catch(parseError){resultJson={success:!1,message:"响应不是有效的JSON格式"}}if(resultJson.success){Date.now();
// 记录上传时间
let now=Date.now();chrome.storage.local.set({lastUploadTime:now},function(){}),
// 显示上传成功的通知
showSyncSuccessNotification("upload")}}}catch(error){}finally{
// 释放全局同步锁
await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}}
// 执行下载操作的函数
async function performDownload(type,needShow){Date.now();
// 通知popup显示0%进度
safeSendMessage({action:"syncProgressUpdate",current:0,total:100,// 初始值，后续会被更新
percentage:0});try{
// 检查全局同步锁，防止并发执行，添加超时机制
var lockResult=await new Promise(resolve=>{chrome.storage.local.get(["globalSyncLock"],function(result){resolve(result.globalSyncLock)})});
// 检查锁是否超时（超过5分钟）
if(lockResult){let lockTime=parseInt(lockResult);if(isNaN(lockTime)||!(3e5<Date.now()-lockTime))return;await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}
// 设置全局同步锁，存储当前时间戳
let lockTime=Date.now().toString(),result=(await new Promise(resolve=>{chrome.storage.local.set({globalSyncLock:lockTime},function(){resolve()})}),
// 添加手动下载历史记录
HistoryManager.addHistory("手动下载",!1),await new Promise(resolve=>{chrome.storage.local.get(["identify","BASE_URL","version"],function(data){resolve(data)})}));
// 直接使用从存储中获取的 identify 值，而不是依赖全局变量
if(result.identify){result.BASE_URL||(result.BASE_URL="http://127.0.0.1:9999");var header={code:"1006",identify:result.identify},checkRes=(Date.now(),await sendXhrRequest("POST",result.BASE_URL,header,null));Date.now();let jsonRes;try{jsonRes="string"==typeof checkRes?JSON.parse(checkRes):checkRes}catch(parseError){
// 创建一个默认的响应对象，避免后续代码出错
jsonRes={success:!1,message:"响应不是有效的JSON格式",message:{hasSafari:!1,hasChrome:!1},source:{hasSafari:!1,hasChrome:!1}}}if(jsonRes.source.hasSafari||jsonRes.source.hasChrome){
// 使用parseInt()将字符串转换为整数
var versionString=result.version||"0";let versionInt=parseInt(versionString,10);isNaN(versionInt)&&(versionInt=0),jsonRes.version<=versionInt?
// 发送100%进度更新
safeSendMessage({action:"syncProgressUpdate",current:0,total:0,percentage:100}):(type="Chrome",
// 设置下载状态
chrome.storage.local.set({isDownloading:"1"},function(){
// 直接传递 identify 值，而不是依赖全局变量
importBookmarksFromURL(result.BASE_URL,result.identify,type)}))}}}catch(error){
// 确保在出错时也清除下载状态
chrome.storage.local.set({isDownloading:"0"})}finally{
// 释放全局同步锁
await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}}
// 检查本地重复书签的函数
function checkLocalDuplicateBookmarks(){Date.now();chrome.bookmarks.getTree(function(bookmarkTreeNodes){if(bookmarkTreeNodes&&0!==bookmarkTreeNodes.length){let foundBookmarksBar=!1;
// 只检查书签栏中的书签（与服务端逻辑保持一致）
for(var rootNode of bookmarkTreeNodes)if(rootNode.children&&Array.isArray(rootNode.children)){for(var child of rootNode.children)
// 只处理书签栏（index为0的节点）
if(("Bookmarks Bar"===child.title||"书签栏"===child.title)&&"1"===child.id){foundBookmarksBar=!0,
// 检查书签栏中的重复书签（同一父节点下）
checkDuplicateInSameParent(child.children,"书签栏");break}if(foundBookmarksBar)break}foundBookmarksBar;Date.now()}})}
// 检查同一父节点下的重复书签（与服务端逻辑保持一致）
function checkDuplicateInSameParent(bookmarks,location){if(bookmarks&&Array.isArray(bookmarks)){var bookmark,titleSet=new Set,titleUrlSet=new Set;let duplicateCount=0,duplicateTitleCount=0;for(bookmark of bookmarks){var duplicateMessage,title=bookmark.title,url=bookmark.url;
// 跳过文件夹（没有URL的书签）
url&&(titleUrlSet.has(url=title+"|"+url)?(
// 发现重复，添加到历史记录
duplicateCount++,duplicateMessage=`发现重复书签: "${title}" (${location})`,HistoryManager.addHistory(duplicateMessage,!0)):titleUrlSet.add(url),
// 检查标题是否重复（即使URL不同）
titleSet.has(title)?(
// 发现重复标题，添加到历史记录
duplicateTitleCount++,duplicateMessage=`发现重复书签标题: "${title}" (${location})`,HistoryManager.addHistory(duplicateMessage,!0)):titleSet.add(title));
// 检查标题和URL的组合是否重复（与服务端逻辑保持一致）
}}}
// 执行删除本地书签操作的函数
async function performDeleteLocalBookmarks(){try{
// 删除所有本地书签
await new Promise(resolve=>{chrome.storage.local.remove("version",function(){chrome.bookmarks.getTree(function(bookmarkTreeNodes){let deletePromises=[];bookmarkTreeNodes.forEach(node=>{deletePromises.push(new Promise(resolve=>{deleteBookmarkNode(node,resolve)}))}),Promise.all(deletePromises).then(()=>{resolve()}).catch(error=>{resolve()})})})})}catch(error){}}
// 递归删除书签节点
//=============could be deleted==============
function deleteBookmarkNode(node,callback){if(node.children){let deletePromises=[];node.children.forEach(folder=>{"1"!==folder.id&&"2"!==folder.id||folder.children&&folder.children.forEach(child=>{deletePromises.push(new Promise(resolve=>{try{chrome.storage.local.set({isDownloading:"1"},function(){chrome.bookmarks.removeTree(child.id,()=>{resolve()})})}catch(e){resolve()}}))})}),Promise.all(deletePromises).then(()=>{callback&&callback()}).catch(error=>{callback&&callback()})}else callback&&callback()}