let BASE_ENV1="Chrome",identify=(importScripts("i18n-helper.js"),importScripts("queue.js"),importScripts("tab_manager.js"),importScripts("compression.js"),importScripts("pako.min.js"),""),version="",searchWindowId=null,localHeartbeatVersion=0,MAX_HEARTBEAT_VERSION=2147483646;// Integer.MAX_VALUE - 1
// 时间格式化工具函数
function getFormattedTimestamp(){var now=new Date;return now.getFullYear()+`-${String(now.getMonth()+1).padStart(2,"0")}-${String(now.getDate()).padStart(2,"0")} ${String(now.getHours()).padStart(2,"0")}:${String(now.getMinutes()).padStart(2,"0")}:`+String(now.getSeconds()).padStart(2,"0")}
// 设置扩展图标
function setExtensionIcon(isConnected){chrome.action.setIcon({path:isConnected?{16:"icons/sync/s_icon16.png",32:"icons/sync/s_icon32.png",48:"icons/sync/s_icon48.png",128:"icons/sync/s_icon128.png"}:{16:"icons/icon16.png",32:"icons/icon32.png",48:"icons/icon48.png",128:"icons/icon128.png"}},()=>{chrome.runtime.lastError})}
// WebSocket 连接管理
let wsConnection=null,wsReconnectTimer=null,wsHeartbeatTimer=null,wsHeartbeatCheckTimer=null,wsBookmarkUpdateTimer=null,wsIsConnecting=!1,wsIsRegistered=!1,wsLastConnectRequestTime=0,WS_RECONNECT_INTERVAL=5e3,WS_HEARTBEAT_INTERVAL=2e4,WS_HEARTBEAT_TIMEOUT=6e4,WS_BOOKMARK_UPDATE_DEBOUNCE=1e3,WS_CONNECT_REQUEST_COOLDOWN=2e3;// 连接请求冷却时间 2 秒
// 建立 WebSocket 连接
function connectWebSocket(source="unknown"){wsConnection;
// ========== 阶段1：严格检查是否需要创建新连接 ==========
// 检查0：冷却时间检查（防止短时间内重复请求）
var now=Date.now();if(now-wsLastConnectRequestTime<WS_CONNECT_REQUEST_COOLDOWN)return!1;
// 检查1：是否正在连接中
if(wsIsConnecting)return!1;
// 检查2：连接已存在且已注册（理想状态，直接复用）
if(wsConnection&&wsConnection.readyState===WebSocket.OPEN&&wsIsRegistered)
// 额外验证：发送一个心跳测试消息，确保连接真的可用
try{return wsConnection.send(JSON.stringify({action:"heartbeat_test"})),!0}catch(error){
// 连接已断开，关闭并重新连接
closeWebSocket();
// 继续执行下面的创建新连接逻辑
}else wsConnection&&wsConnection.readyState===WebSocket.OPEN&&wsIsRegistered;
// 检查3：防抖检查
if(wsReconnectTimer)return!1;
// 检查4：连接存在但未注册（需要重新注册或重新连接）
if(wsConnection){if(wsConnection.readyState===WebSocket.OPEN&&!wsIsRegistered)
// 尝试重新注册
return chrome.storage.local.get(["identify"],function(result){if(result.identify)try{var registerMessage={action:"register",identify:result.identify};wsConnection.send(JSON.stringify(registerMessage))}catch(error){
// 注册失败，关闭连接并创建新连接
closeWebSocket(),doConnect(source)}}),!0;if(wsConnection.readyState===WebSocket.CONNECTING)return wsIsConnecting=!0;try{wsConnection.close(1e3,"Reconnecting")}catch(error){}}
// ========== 阶段2：创建新连接 ==========
return wsLastConnectRequestTime=now,// 更新最后连接请求时间
doConnect(source),!0}
// 实际创建 WebSocket 连接的内部函数
function doConnect(source=0){wsConnection,
// 立即设置连接标志，防止异步回调导致重复连接
wsIsConnecting=!0,wsIsRegistered=!1;
// 从 storage 中检查 WebSocket 连接状态（Service Worker 休眠后恢复）
chrome.storage.local.get(["wsStatus"],function(result){"connected"!==result.wsStatus&&result.wsStatus}),chrome.storage.local.get(["BASE_URL","identify","autoSync"],function(result){var baseUrl=result.BASE_URL;let identify=result.identify;result=result.autoSync;
// 检查是否启用自动同步
if(!1!==result)wsIsConnecting=!1,chrome.storage.local.set({wsStatus:"disconnected"}),setExtensionIcon(!1);else if(baseUrl&&identify){
// 将 HTTP URL 转换为 WebSocket URL
let wsUrl=baseUrl.replace(/^http/,"ws")+"/ws";
// 更新 WebSocket 状态到存储
chrome.storage.local.set({wsStatus:"connecting"});try{(wsConnection=new WebSocket(wsUrl)).onopen=function(event){wsIsConnecting=!1,
// 更新 WebSocket 状态到存储
chrome.storage.local.set({wsStatus:"connected"}),
// 设置连接状态图标
setExtensionIcon(!0),
// 延迟发送注册消息，确保连接完全建立
setTimeout(function(){
// 双重检查：连接存在、状态为 OPEN、尚未注册
wsConnection&&wsConnection.readyState===WebSocket.OPEN&&!wsIsRegistered?
// 发送注册消息
chrome.storage.local.get(["heartbeatVersion"],function(hbResult){hbResult=hbResult.heartbeatVersion||0,hbResult={action:"register",identify:identify,heartbeatVersion:hbResult};try{wsConnection.send(JSON.stringify(hbResult))}catch(error){
// 发送失败，关闭连接并重试
return closeWebSocket(),void scheduleReconnect()}
// 启动心跳
startHeartbeat(),
// 清除重连定时器
wsReconnectTimer&&(clearTimeout(wsReconnectTimer),wsReconnectTimer=null)}):(wsConnection&&wsConnection.readyState===WebSocket.OPEN&&wsIsRegistered,chrome.storage.local.set({wsStatus:"error"}),
// 尝试重新连接
scheduleReconnect())},100)},wsConnection.onmessage=function(event){try{let message=JSON.parse(event.data);if("bookmark_update"===message.action)handleBookmarkUpdate();else if("register"===message.action){var serverHeartbeatVersion;message.success?// 标记为已注册
// 检查是否需要拉取书签
(wsIsRegistered=!0)===message.shouldPull&&(serverHeartbeatVersion=message.heartbeatVersion||0,
// 更新本地心跳计数器
localHeartbeatVersion=serverHeartbeatVersion,chrome.storage.local.set({heartbeatVersion:localHeartbeatVersion},function(){}),
// 触发书签拉取
handleBookmarkUpdate()):(
// 关闭连接
closeWebSocket(),chrome.storage.local.set({autoSync:!0},function(){
// 显示错误提示
var maxConnections=message.maxConnections||2,maxConnections=chrome.i18n.getMessage("websocket_connection_limit_exceeded",{maxConnections:maxConnections})||`WebSocket 连接失败：超过最大连接数限制（每个账号最多 ${maxConnections} 个连接），已自动切换到手动同步模式`;chrome.notifications.create({type:"basic",iconUrl:"icons/icon128.png",title:"UniSync",message:maxConnections})}))}else if("heartbeat"===message.action){let serverHeartbeatVersion=message.heartbeatVersion;
// 记录最后心跳时间
chrome.storage.local.set({lastHeartbeatTime:Date.now()}),
// 比较本地和服务器的心跳计数器，判断是否需要拉取书签
chrome.storage.local.get(["autoSync","heartbeatVersion"],function(result){
// 从 storage 读取本地计数器，更新全局变量
localHeartbeatVersion=result.heartbeatVersion||0,
// 只在自动同步模式下触发拉取
!1===result.autoSync&&(serverHeartbeatVersion,localHeartbeatVersion,shouldPullBookmarks(localHeartbeatVersion,serverHeartbeatVersion))&&(
// 更新本地计数器（全局变量和 storage）
localHeartbeatVersion=serverHeartbeatVersion,chrome.storage.local.set({heartbeatVersion:localHeartbeatVersion}),
// 触发书签拉取
handleBookmarkUpdate())})}}catch(error){}},wsConnection.onerror=function(error){wsIsConnecting=!1,wsIsRegistered=!1,// 重置注册状态
// 更新 WebSocket 状态到存储
chrome.storage.local.set({wsStatus:"error"}),
// 设置默认图标
setExtensionIcon(!1),
// 检查是否启用自动同步模式，如果是则自动重连
chrome.storage.local.get(["autoSync","BASE_URL","identify"],function(result){
// autoSync = false 表示自动同步模式（复选框未勾选）
!1===result.autoSync&&result.BASE_URL&&result.identify&&scheduleReconnect()})},wsConnection.onclose=function(event){wsIsConnecting=!1,wsIsRegistered=!1,// 重置注册状态
stopHeartbeat(),
// 更新 WebSocket 状态到存储
chrome.storage.local.set({wsStatus:"disconnected"}),
// 设置默认图标
setExtensionIcon(!1),
// 检查是否启用自动同步模式，如果是则自动重连
chrome.storage.local.get(["autoSync","BASE_URL","identify"],function(result){
// autoSync = false 表示自动同步模式（复选框未勾选）
// 只有在自动同步模式下才自动重连
(!1===result.autoSync&&result.BASE_URL&&result.identify||1e3!==event.code)&&scheduleReconnect()})}}catch(error){wsIsConnecting=!1,wsIsRegistered=!1,// 重置注册状态
// 更新 WebSocket 状态到存储
chrome.storage.local.set({wsStatus:"error"}),
// 设置默认图标
setExtensionIcon(!1),
// 检查是否启用自动同步模式，如果是则自动重连
chrome.storage.local.get(["autoSync","BASE_URL","identify"],function(result){
// autoSync = false 表示自动同步模式（复选框未勾选）
!1===result.autoSync&&result.BASE_URL&&result.identify&&scheduleReconnect()})}}else wsIsConnecting=!1,chrome.storage.local.set({wsStatus:"disconnected"}),setExtensionIcon(!1)})}
// 关闭 WebSocket 连接
function closeWebSocket(){if(stopHeartbeat(),wsIsRegistered=!1,// 重置注册状态
wsReconnectTimer&&(clearTimeout(wsReconnectTimer),wsReconnectTimer=null),wsBookmarkUpdateTimer&&(clearTimeout(wsBookmarkUpdateTimer),wsBookmarkUpdateTimer=null),wsConnection){try{wsConnection.readyState!==WebSocket.OPEN&&wsConnection.readyState!==WebSocket.CONNECTING||wsConnection.close(1e3,"用户主动关闭")}catch(error){}wsConnection=null}wsIsConnecting=!1,
// 更新 WebSocket 状态到存储
chrome.storage.local.set({wsStatus:"disconnected"}),
// 设置默认图标
setExtensionIcon(!1)}
// 安排重连
function scheduleReconnect(){wsReconnectTimer&&clearTimeout(wsReconnectTimer),wsReconnectTimer=setTimeout(function(){connectWebSocket("scheduleReconnect")},WS_RECONNECT_INTERVAL)}
// 启动心跳
function startHeartbeat(){stopHeartbeat(),
// 先记录当前时间为最后心跳时间
chrome.storage.local.set({lastHeartbeatTime:Date.now()}),
// 发送心跳的定时器
wsHeartbeatTimer=setInterval(function(){wsConnection&&wsConnection.readyState===WebSocket.OPEN?chrome.storage.local.get(["identify","heartbeatVersion"],function(result){var identify=result.identify,result=result.heartbeatVersion||0;if(identify){identify={action:"heartbeat",cname:BASE_ENV1,identify:identify,heartbeatVersion:result};try{wsConnection.send(JSON.stringify(identify))}catch(error){closeWebSocket(),scheduleReconnect()}}}):wsConnection},WS_HEARTBEAT_INTERVAL),
// 心跳超时检测定时器
wsHeartbeatCheckTimer=setInterval(function(){chrome.storage.local.get(["lastHeartbeatTime"],function(result){result=result.lastHeartbeatTime||0,result=Date.now()-result;result>WS_HEARTBEAT_TIMEOUT&&(closeWebSocket(),scheduleReconnect())})},WS_HEARTBEAT_TIMEOUT/2)}
// 停止心跳
function stopHeartbeat(){wsHeartbeatTimer&&(clearInterval(wsHeartbeatTimer),wsHeartbeatTimer=null),wsHeartbeatCheckTimer&&(clearInterval(wsHeartbeatCheckTimer),wsHeartbeatCheckTimer=null)}
// 处理书签更新
function handleBookmarkUpdate(){
// 清除之前的定时器
wsBookmarkUpdateTimer&&clearTimeout(wsBookmarkUpdateTimer),
// 设置新的防抖定时器
wsBookmarkUpdateTimer=setTimeout(function(){chrome.storage.local.get(["defaultBrowser","identify","BASE_URL","heartbeatVersion"],function(result){let browser=result.defaultBrowser||"Chrome",identify=result.identify,baseUrl=result.BASE_URL;identify&&
// 检查是否正在下载
chrome.storage.local.get(["isDownloading"],function(downloadResult){"1"!==downloadResult.isDownloading&&
// 调用现有的下载函数
download(browser,!1,identify,baseUrl)})})},WS_BOOKMARK_UPDATE_DEBOUNCE)}
// 判断是否需要拉取书签（基于心跳计数器）
function shouldPullBookmarks(localVersion,serverVersion){
// 如果计数器相等，不需要拉取
return localVersion!==serverVersion&&(
// 正常情况：服务器计数器大于本地计数器
0<(serverVersion=serverVersion-localVersion)||serverVersion<-(MAX_HEARTBEAT_VERSION/2));
// 计算差值
}
// 安全的消息发送函数，避免popup关闭时的连接错误
function safeSendMessage(message,callback){try{chrome.runtime.sendMessage(message,function(response){chrome.runtime.lastError||callback&&callback(response)})}catch(error){}}
//=============could be deleted==============
// 创建一个返回Promise的安全消息发送函数
function safeSendMessagePromise(message){return new Promise(resolve=>{try{chrome.runtime.sendMessage(message,function(response){chrome.runtime.lastError?resolve(null):resolve(response)})}catch(error){resolve(null)}})}
// 历史记录管理函数
let HistoryManager={
// 添加操作历史记录
addHistory:function(operation,isAuto=!1){let now=new Date;let historyItem=now.getMonth()+1+`-${now.getDate()} ${now.getHours().toString().padStart(2,"0")}:${now.getMinutes().toString().padStart(2,"0")}:`+now.getSeconds().toString().padStart(2,"0")+" "+(isAuto?"自动 ":"手动 ")+operation;chrome.storage.local.get(["opt-history"],function(result){let history=result["opt-history"]||[];history.unshift(historyItem),// 添加到数组开头
// 限制历史记录数量，保留最近50条
50<history.length&&(history=history.slice(0,50)),chrome.storage.local.set({"opt-history":history},function(){chrome.storage.local.set({lastUploadTime:Date.now()},function(){})})})},
// 获取操作历史记录
getHistory:function(callback){chrome.storage.local.get(["opt-history"],function(result){result=result["opt-history"]||[];callback(result)})},
// 清除操作历史记录
clearHistory:function(){chrome.storage.local.set({"opt-history":[]},function(){})}},messageQueue=new MessageQueue;
// 完整使用示例
// 创建消息队列实例
//=============could be deleted==============
function toggleFeature(){chrome.storage.local.set({search:"1"},function(data){createSearchWindow()})}
//=============could be deleted==============
function createSearchWindow(){
// 如果搜索窗口已经存在，就关闭它
null!==searchWindowId?chrome.windows.remove(searchWindowId,function(){chrome.runtime.lastError,searchWindowId=null}):chrome.windows.getAll({windowTypes:["normal"]},function(windows){var windows=windows[0],left=Math.max(0,Math.round(windows.left+(windows.width-700)/2)),windows=Math.max(0,Math.round(windows.top+(windows.height-300)/2)),searchUrl=chrome.runtime.getURL("search.html");chrome.windows.create({url:searchUrl,focused:!0,width:700,height:300,type:"panel",left:left,top:windows},function(createdWindow){if(!chrome.runtime.lastError){searchWindowId=createdWindow.id;let focusListener=function(windowId){windowId!==chrome.windows.WINDOW_ID_NONE&&windowId!==searchWindowId&&null!==searchWindowId&&(chrome.windows.onFocusChanged.removeListener(focusListener),chrome.windows.remove(searchWindowId,function(){chrome.runtime.lastError,searchWindowId=null}))};chrome.windows.onFocusChanged.addListener(focusListener),chrome.windows.onRemoved.addListener(function(windowId){windowId===searchWindowId&&(searchWindowId=null)})}})})}
// ========== 以下代码已废弃，使用 WebSocket 实现实时同步 ==========
// 单独的函数用于安排下一次任务执行
function scheduleAlarm(){chrome.storage.local.get(["syncInterval"],function(result){
// 如果result.syncInterval 存在且为数字
result.syncInterval&&!isNaN(result.syncInterval)&&(interval=result.syncInterval,
// 检查是否已存在同名告警
chrome.alarms.get("keep-alive",function(existingAlarm){if(existingAlarm)
// 如果告警已存在，计算剩余时间
{var now=new Date;existingAlarm.scheduledTime,now.getTime()}else{
// 没有现有告警，创建新的
let now=new Date;new Date(now.getTime()+6e4*interval);// 转换为毫秒
//                console.log(`scheduleAlarm: 创建新的告警，下次执行时间: ${nextAlarmTime.toISOString()}, ${interval}分钟后`);
chrome.alarms.create("keep-alive",{periodInMinutes:Number(interval)}),
// 获取并显示当前告警信息
chrome.alarms.get("keep-alive",function(alarm){alarm&&new Date(alarm.scheduledTime)})}}))})}function performTask(){
// 检查全局同步锁，防止并发执行，添加超时机制
chrome.storage.local.get(["globalSyncLock"],function(result){
// 检查锁是否超时（超过5分钟）
if(result.globalSyncLock){result=parseInt(result.globalSyncLock);if(isNaN(result)||!(3e5<Date.now()-result))return;chrome.storage.local.remove("globalSyncLock")}let browser="";chrome.storage.local.get(["defaultBrowser","identify","autoSync","BASE_URL"],function(result){let item=result.identify;""===item||null==item||(""!==(browser=result.defaultBrowser)&&null!=browser||(
// 任务完成后安排下一次执行
browser="Chrome",chrome.storage.local.set({defaultBrowser:"Chrome"})),result.autoSync)||(
// 执行本地重复书签检查
checkLocalDuplicateBookmarks(),
// 添加自动同步历史记录
HistoryManager.addHistory("同步",!0),
// 设置全局同步锁，存储当前时间戳
chrome.storage.local.set({globalSyncLock:Date.now().toString()},function(){
// 调用下载函数，不使用防抖版本以确保执行
download(browser,!1,item,result.BASE_URL).finally(()=>{
// 确保在任何情况下都释放全局同步锁
chrome.storage.local.remove("globalSyncLock"),chrome.storage.local.set({isDownloading:"0"})})}))})})}async function download(type,needShow,item,baseUrl){var lockResult=await new Promise(resolve=>{chrome.storage.local.get(["downloadLock"],function(result){resolve(result.downloadLock)})});
// 检查锁是否超时（超过5分钟）
if(lockResult){lockResult=parseInt(lockResult);if(isNaN(lockResult)||!(3e5<Date.now()-lockResult))return Promise.resolve();await new Promise(resolve=>{chrome.storage.local.remove("downloadLock",function(){resolve()})})}
// 设置下载锁，存储当前时间戳
await new Promise(resolve=>{chrome.storage.local.set({downloadLock:Date.now().toString()},function(){resolve()})});try{
// 通知popup显示进度条
safeSendMessage({action:"syncProgressUpdate",current:0,total:100,// 初始值，后续会被更新
percentage:0});let jsonRes=await sendXhrRequest("POST",baseUrl,{code:"1006",identify:item},null);if(!jsonRes.source.hasSafari&&!jsonRes.source.hasChrome)return Promise.resolve();
// 使用parseInt()将字符串转换为整数
let versionString;return new Promise(resolve=>{chrome.storage.local.get(["version"],function(res){versionString=res.version,versionInt=parseInt(versionString,10),isNaN(versionInt)&&(versionInt=0),jsonRes.version<=versionInt?(
// 即使是最新版本，也要发送完成消息，但不隐藏进度条
safeSendMessage({action:"syncProgressUpdate",current:0,total:0,percentage:100}),resolve()):chrome.storage.local.set({isDownloading:"1"},function(d){var isSafari=jsonRes.message.hasSafari&&!jsonRes.message.hasChrome||"Safari"===type;
// 直接传递 identify 值，而不是依赖全局变量
importBookmarksFromURL(baseUrl,item,isSafari?"Safari":"Chrome"),resolve()})})})}catch(error){throw safeSendMessage({action:"syncProgressUpdate",error:!0}),error}finally{await new Promise(resolve=>{chrome.storage.local.remove("downloadLock",function(){resolve()})})}}async function importBookmarksFromURL(url,identify,browser){try{
// 记录开始时间
Date.now();let syncOtherFolders=await new Promise(resolve=>{chrome.storage.local.get(["syncOtherFolders"],function(data){resolve(data.syncOtherFolders||!1)})});chrome.storage.local.get(["version","identify"],function(resultVersion){version=resultVersion.version,versionInt=parseInt(version,10),isNaN(versionInt)&&(version="0");resultVersion={identify:resultVersion.identify,code:"1002",tag:browser,version:version};Date.now();sendXhrRequest("GET",url,resultVersion,null).then(response=>{Date.now();try{let bookmarks=response.message;if(void 0===response.success||response.success){Date.now();chrome.storage.local.set({version:response.version}),chrome.bookmarks.getTree(function(bookmarkTreeNodes){
// 根据 syncOtherFolders 配置决定删除哪些书签
syncOtherFolders?
// 如果开启了同步其他书签文件夹，删除所有书签
bookmarkTreeNodes.forEach(deleteNode):
// 如果未开启同步其他书签文件夹，删除书签栏和其他书签文件夹中的书签
bookmarkTreeNodes.forEach(function(node){node.children&&node.children.forEach(function(folder){"1"!==folder.id&&"2"!==folder.id||// 删除书签栏 (id="1") 和其他书签文件夹 (id="2")
folder.children&&folder.children.forEach(function(child){chrome.bookmarks.removeTree(child.id)})})});
// 计算总的书签数量
let totalBookmarks=0;
// 定义进度回调函数
function progressCallback(current,total,percentage){
// 向popup发送进度更新
safeSendMessage({action:"syncProgressUpdate",current:current,total:total,percentage:percentage})}
// 递归计算节点总数
function countNodes(nodes){let count=0;return nodes.forEach(node=>{count++,node.children&&(count+=countNodes(node.children))}),count}
// 创建一个共享的已创建计数器
bookmarks[0].children.forEach(node=>{("Safari"!==browser||"BookmarksBar"!==node.title)&&"1"!==node.id&&"2"!==node.id||(totalBookmarks+=countNodes(node.children))});let createdCounter={count:0},importPromises=[];
// 处理每个顶级节点
bookmarks[0].children.forEach(node=>{"Safari"===browser&&"BookmarksBar"===node.title||"1"===node.id?
// 书签栏，始终导入
importPromises.push(addBookmarks(node.children,"1",progressCallback,totalBookmarks,createdCounter)):"2"===node.id&&syncOtherFolders&&importPromises.push(addBookmarks(node.children,"2",progressCallback,totalBookmarks,createdCounter))}),
// 等待所有导入完成
Promise.all(importPromises).then(function(results){Date.now();
// 计算总体结果
let total=0,success=0,error=0;results.forEach(result=>{total+=result.total,success+=result.success,error+=result.error}),
// 向popup发送完成消息，但不隐藏进度条
safeSendMessage({action:"syncProgressUpdate",current:total,total:total,percentage:100}),
// 显示下载成功的通知
showSyncSuccessNotification("download"),
// 更新本地 heartbeatVersion 为服务器版本
chrome.storage.local.get(["heartbeatVersion"],function(hbResult){var hbResult=hbResult.heartbeatVersion||0,newHeartbeatVersion=parseInt(response.version,10)||0;
// 服务器返回的 response.version 就是最新的版本号
hbResult<newHeartbeatVersion&&chrome.storage.local.set({heartbeatVersion:newHeartbeatVersion})}),
// 设置下载完成状态
chrome.storage.local.set({isDownloading:"0"})}).catch(function(error){Date.now();
// 即使出错也设置下载完成状态
chrome.storage.local.set({isDownloading:"0"}),
// 向popup发送错误消息
safeSendMessage({action:"syncProgressUpdate",error:!0})})})}}catch(e){Date.now();
// 即使出错也设置下载完成状态
chrome.storage.local.set({isDownloading:"0"})}}).catch(function(error){chrome.storage.local.set({isDownloading:"0"}),safeSendMessage({action:"syncProgressUpdate",error:!0})})})}catch(error){Date.now();
// 即使出错也设置下载完成状态
chrome.storage.local.set({isDownloading:"0"})}}function addBookmarks(nodes,parentId,progressCallback=null,totalNodesCount=null,createdCounter=null){
// 增加并发限制来提高性能，同时避免过多的并行操作
let index=0;// 从10增加到20
nodes.length;
// 如果没有提供已创建计数器，则创建一个新的
// 开始处理批次
return null===createdCounter&&(createdCounter={count:0}),
// 如果没有提供总节点数，则计算它
null===totalNodesCount&&(totalNodesCount=
// 递归计算总节点数（包括子节点）
function countTotalNodes(nodes){let count=0;return nodes.forEach(node=>{count++,node.children&&0<node.children.length&&(count+=countTotalNodes(node.children))}),count}(nodes)),0<nodes.length?function processBatch(){
// 收集当前批次的节点
for(var promises,batch=[];index<nodes.length&&batch.length<20;)batch.push(nodes[index]),index++;return 0===batch.length?Promise.resolve():(
// 等待当前批次完成
promises=batch.map(function(node){let newNode={parentId:parentId,title:node.title,url:node.url};return new Promise(function(resolve){node.url?
// 创建书签
chrome.bookmarks.create(newNode,function(result){
// 更新进度
var progress;chrome.runtime.lastError||
// 成功创建，更新计数器
createdCounter.count++,progressCallback&&(progress=Math.round(createdCounter.count/totalNodesCount*100),progressCallback(createdCounter.count,totalNodesCount,progress)),resolve()}):
// 创建书签文件夹
chrome.bookmarks.create(newNode,function(createdNode){chrome.runtime.lastError||
// 成功创建，更新计数器
createdCounter.count++,node.children&&0<node.children.length&&createdNode?
// 递归处理子节点，传递相同的计数器和总节点数
addBookmarks(node.children,createdNode.id,progressCallback,totalNodesCount,createdCounter).then(function(){resolve()}).catch(function(error){resolve()}):(
// 更新进度
progressCallback&&(createdNode=Math.round(createdCounter.count/totalNodesCount*100),progressCallback(createdCounter.count,totalNodesCount,createdNode)),resolve())})})}),Promise.all(promises).then(function(){
// 如果还有更多节点需要处理，继续处理下一批
if(index<nodes.length)
// 添加一个小延迟以避免阻塞UI
return new Promise(function(resolve){setTimeout(function(){processBatch().then(resolve)},10)})}));
// 并行处理当前批次的所有节点
}().then(function(){return{total:createdCounter.count,success:createdCounter.count,error:totalNodesCount-createdCounter.count}}):Promise.resolve({total:0,success:0,error:0})}async function sendXhrRequest(method,url,headers,body){
// 浏览器会自动处理Accept-Encoding头部，所以我们不需要手动设置
// 直接使用原始头部
return messageQueue.enqueue(body,{url:url,method:method,headers:headers})}function deleteNode(node,callback){if(node.children){let folderPromises=[];node.children.forEach(folder=>{if(("1"===folder.id||"2"===folder.id)&&folder.children){
// 批量删除书签以提高性能
let childrenIds=folder.children.map(child=>child.id),index=0;// 增加批处理大小以提高性能
folder=new Promise(resolve=>{
// 开始删除批次
!function deleteBatch(){let batch=childrenIds.slice(index,index+20);if(0===batch.length)resolve();else{let deletedCount=0,errorCount=0;batch.forEach(childId=>{try{chrome.bookmarks.removeTree(childId,function(){chrome.runtime.lastError?errorCount++:deletedCount++,
// 检查是否已完成当前批次的所有删除操作
deletedCount+errorCount===batch.length&&((index+=20)<childrenIds.length?
// 继续删除下一批
setTimeout(deleteBatch,10):
// 所有批次完成
resolve())})}catch(e){errorCount++,
// 检查是否已完成当前批次的所有删除操作
deletedCount+errorCount===batch.length&&((index+=20)<childrenIds.length?
// 继续删除下一批
setTimeout(deleteBatch,10):
// 所有批次完成
resolve())}})}}()});folderPromises.push(folder)}}),
// 等待所有文件夹删除完成
Promise.all(folderPromises).then(()=>{callback&&callback()}).catch(error=>{callback&&callback()})}else callback&&callback()}
// 书签事件监听器 - 统一处理所有书签变化事件
// 统一的书签事件处理函数
function handleBookmarkEvent(eventType,id,info){
// 检查是否正在下载、是否在重建或popup是否打开
chrome.storage.local.get(["isDownloading","popupOpen","autoSync","isRebuilding"],function(data){
// 如果正在下载，直接返回
"1"===data.isDownloading||!0===data.isRebuilding||"1"===data.popupOpen||void 0!==data.autoSync&&data.autoSync||delay_upload(eventType)})}
// 声明防抖定时器变量
// 设置超时时间为60秒，以适应大文件上传/下载
messageQueue.setTimeout(6e4),
// 配置默认请求选项
messageQueue.setRequestOptions({url:"https://bk.ithuajiao.site",method:"POST",headers:{}}),
// 设置消息处理函数 - 发送HTTP请求
messageQueue.setHandler(async(message,options)=>{try{
// 对于大量数据，添加gzip支持
var headers={...options.headers},response=await fetch(options.url,{method:options.method,headers:headers,body:message});
// 注意：我们不手动设置Accept-Encoding头部，因为浏览器会自动处理
if(!response.ok)throw new Error("HTTP error! status: "+response.status);
// 尝试解析响应为JSON
let responseData;try{responseData=await response.json()}catch(parseError){
// 如果JSON解析失败，尝试获取文本内容
var textData=await response.text();
// 创建一个模拟的响应对象
responseData={success:!1,message:"响应不是有效的JSON格式",rawResponse:textData}}return responseData}catch(error){throw error;// 抛出错误让队列处理
}}),chrome.runtime.onMessage.addListener((message,sender,sendResponse)=>{if("no_autoSync"===message.event)chrome.storage.local.set({autoSync:!1},function(){connectWebSocket()}),sendResponse({success:!0});else if("yes_autoSync"===message.event)chrome.storage.local.set({autoSync:!0},function(){closeWebSocket()}),sendResponse({success:!0});else if("plugin_activated"===message.event)chrome.storage.local.get(["BASE_URL","identify","autoSync","defaultBrowser","wsStatus","lastHeartbeatTime"],function(result){identify=result.identify;
// 检查实际连接状态（内存 + storage）
var isActuallyConnected=wsConnection&&wsConnection.readyState===WebSocket.OPEN&&wsIsRegistered,storageSaysConnected="connected"===result.wsStatus,now=(wsConnection,Date.now()),lastHeartbeat=result.lastHeartbeatTime||0,now=6e4<now-lastHeartbeat;
// 检查自动同步模式和 WebSocket 状态
if(!1===result.autoSync){
// 自动操作模式：检查 WebSocket 是否已连接
if(!isActuallyConnected&&result.identify&&result.BASE_URL)connectWebSocket("plugin_activated");else if(isActuallyConnected)
// 连接存在，但检查心跳是否超时
if(now)closeWebSocket(),connectWebSocket("plugin_activated");else
// 额外验证：尝试发送心跳测试消息，确保连接真的可用
try{wsConnection.send(JSON.stringify({action:"heartbeat_test"}))}catch(error){closeWebSocket(),connectWebSocket("plugin_activated")}
// 检查是否启用自动同步，如果启用则触发一次同步
result.identify&&result.BASE_URL&&download(result.defaultBrowser||"Chrome",!1,result.identify,result.BASE_URL)}else!0===result.autoSync&&(
// 手动操作模式：检查 WebSocket 是否已连接，如果已连接则关闭
isActuallyConnected?closeWebSocket():storageSaysConnected&&chrome.storage.local.set({wsStatus:"disconnected"}))});else{if("get_history"===message.action)
// 获取历史记录
return HistoryManager.getHistory(function(history){sendResponse({success:!0,history:history})}),!0;// 保持消息通道开放以进行异步响应
if("clear_history"===message.action)
// 清除历史记录
return HistoryManager.clearHistory(),sendResponse({success:!0}),!0;if("updateTabConfig"===message.event)
// 更新标签页管理器的配置
"undefined"!=typeof tabManager?(tabManager.updateConfig({maxTabs:message.config.maxTabs,timeLimit:message.config.timeLimit}),sendResponse({success:!0})):sendResponse({success:!0,error:"标签页管理器未定义"});else if("ws_connect"===message.event)connectWebSocket("ws_connect_message"),sendResponse({success:!0});else if("ws_disconnect"===message.event)closeWebSocket(),sendResponse({success:!0});else if("ws_reconnect"===message.event)closeWebSocket(),// 先关闭现有连接
setTimeout(function(){connectWebSocket("ws_reconnect_message");// 然后重新连接
},100),sendResponse({success:!0});else{if("upload_bookmarks"===message.action)
// 执行上传操作
return performUpload(message.defaultBrowser),sendResponse({success:!0,message:"上传请求已接收"}),!0;// 保持消息通道开放以进行异步响应
if("download_bookmarks"===message.action)
// 执行下载操作
return performDownload(message.defaultBrowser,message.needShow),sendResponse({success:!0,message:"下载请求已接收"}),!0;// 保持消息通道开放以进行异步响应
{if("delete_local_bookmarks"===message.action)
// 执行删除本地书签操作
return performDeleteLocalBookmarks(),sendResponse({success:!0,message:"删除本地书签请求已接收"}),!0;// 保持消息通道开放以进行异步响应
"set_syncInterval"===message.event?
// ========== 以下代码已废弃，使用 WebSocket 实现实时同步 ==========
/*
            chrome.alarms.clear('keep-alive');
            chrome.storage.local.set({'syncInterval': message.data});
            scheduleAlarm();
            */
// 只保存设置，不使用定时器
chrome.storage.local.set({syncInterval:message.data}):"set_url"===message.event&&chrome.storage.local.set({BASE_URL:message.BASE_URL})}}}}),chrome.runtime.onStartup.addListener(()=>{
// 加载本地心跳计数器
chrome.storage.local.get(["heartbeatVersion"],function(hbResult){localHeartbeatVersion=hbResult.heartbeatVersion||0}),chrome.storage.local.get(["autoSync","defaultBrowser","identify","wsStatus"],function(result){
// 检查 WebSocket 连接状态，如果 storage 中显示已连接但实际上内存中无连接，说明 Service Worker 休眠了
"connected"!==result.wsStatus||wsConnection&&wsConnection.readyState===WebSocket.OPEN?"disconnected"===result.wsStatus&&!1===result.autoSync&&result.identify&&connectWebSocket("onStartup_autoSync"):(
// 重置状态
wsConnection=null,wsIsRegistered=!1,
// 立即重新连接（不使用延迟，避免竞态条件）
(wsIsConnecting=!1)===result.autoSync&&result.identify&&connectWebSocket("onStartup_state_check")),
// autoSync为true表示需要手动操作（手动同步模式，复选框勾选），false表示自动操作（自动同步模式，复选框未勾选）
""!==result.autoSync&&void 0!==result.autoSync&&!result.autoSync||chrome.storage.local.set({autoSync:!0}),
// 判断是否需要默认设置
""!==result.defaultBrowser&&void 0!==result.defaultBrowser||chrome.storage.local.set({defaultBrowser:"chrome"}),
// 异步拉取最新书签（在浏览器启动时）
// 注意：这是异步操作，不会阻塞 onStartup 事件的完成
// 只在用户已登录（identify 存在）、配置了 BASE_URL 且 WebSocket 未连接时执行
// 避免与 WebSocket 自动同步功能冲突
result.identify&&
// 使用 setTimeout 确保异步执行，不阻塞其他初始化逻辑
setTimeout(()=>{chrome.storage.local.get(["BASE_URL","defaultBrowser","autoSync","wsStatus"],function(storageResult){storageResult.BASE_URL&&!1===storageResult.autoSync&&"connected"!==storageResult.wsStatus&&download(storageResult.defaultBrowser||"Chrome",!1,result.identify,storageResult.BASE_URL).then(()=>{}).catch(error=>{chrome.notifications.create({type:"basic",iconUrl:chrome.runtime.getURL("icons/icon48.png"),title:"UniSync",message:"启动时书签同步失败，请手动点击刷新按钮"})})})},3e3)})}),chrome.runtime.onConnect.addListener(port=>{"popup"===port.name&&(
//        console.log(`chrome.runtime.onConnect: popup连接, 时间: ${new Date().toISOString()}`);
chrome.storage.local.get(["autoSync"],function(autoSyncResult){!1===autoSyncResult.autoSync&&
// 获取当前告警信息
chrome.alarms.get("keep-alive",function(alarm){var now;alarm&&(new Date(alarm.scheduledTime),now=new Date,alarm.scheduledTime,now.getTime())})}),chrome.storage.local.set({popupOpen:"1"},function(data){
// popup打开时，不干扰定时器
}),port.onDisconnect.addListener(()=>{
//            console.log(`popup断开连接: ${new Date().toISOString()}`);
chrome.storage.local.set({popupOpen:"0"},function(data){
// popup关闭后，检查定时器状态
chrome.alarms.get("keep-alive",function(alarm){alarm||
// 如果定时器不存在（可能因为其他原因被清除），则重新创建
scheduleAlarm()})})}))}),
// ========== 以下代码已废弃，使用 WebSocket 实现实时同步 ==========
/*
chrome.alarms.onAlarm.addListener((alarm) => {
    if (alarm.name === 'keep-alive') {
        console.log(`chrome.alarms.onAlarm: 告警触发, 时间: ${new Date().toISOString()}`);
        performTask();
    }
});
*/
// ========== 废弃代码结束 ==========
// background.js
chrome.runtime.onInstalled.addListener(detail=>{"update"===detail.reason?
// 更新时根据 autoSync 状态决定是否建立 WebSocket 连接
chrome.storage.local.get(["autoSync","identify"],function(result){!1===result.autoSync&&result.identify&&connectWebSocket("onInstalled_update")}):detail.reason,chrome.storage.local.get(["contextMenuEnabled"],function(result){}),chrome.storage.local.get("firstInstall",data=>{data.firstInstall||(chrome.tabs.create({url:"welcome.html"}),chrome.storage.local.set({firstInstall:!0}))}),chrome.storage.local.get("autoSync",data=>{null==data.autoSync&&
// 默认设置为手动同步模式（复选框勾选，autoSync=true）
chrome.storage.local.set({autoSync:!0})})}),chrome.commands.onCommand.addListener(command=>{"open-search"===command&&chrome.tabs.query({active:!0,currentWindow:!0},tabs=>{toggleFeature()})}),chrome.bookmarks.onMoved.addListener((id,bookmark)=>{handleBookmarkEvent("onMoved",id,bookmark)}),chrome.bookmarks.onCreated.addListener((id,bookmark)=>{handleBookmarkEvent("onCreated",id,bookmark)}),chrome.bookmarks.onRemoved.addListener((id,removeInfo)=>{handleBookmarkEvent("onRemoved",id,removeInfo)}),chrome.bookmarks.onChanged.addListener((id,changeInfo)=>{handleBookmarkEvent("onChanged",id,changeInfo)}),chrome.bookmarks.onChildrenReordered.addListener((id,reorderInfo)=>{handleBookmarkEvent("onChildrenReordered",id,reorderInfo)}),chrome.bookmarks.onImportEnded.addListener(()=>{handleBookmarkEvent("onImportEnded",null,null)});let uploadTimer=null,downloadDebounceTimer=null;
// 声明下载防抖定时器变量
// 过滤书签树，只保留书签栏中的书签
function filterBookmarksTree(bookmarkTree){var bookmarksBar;
// 查找书签栏节点（通常是第一个节点，id为"1"）
return bookmarkTree&&Array.isArray(bookmarkTree)&&(bookmarksBar=bookmarkTree.find(node=>"1"===node.id||"Bookmarks bar"===node.title||"书签栏"===node.title))?[bookmarksBar]:bookmarkTree}function delay_upload(eventType){clearTimeout(uploadTimer),// 清除之前的定时器
uploadTimer=setTimeout(function(){chrome.storage.local.get(["defaultBrowser","isDownloading","autoSync","popupOpen","isRebuilding"],function(data){
// 检查自动同步设置
void 0!==data.autoSync&&data.autoSync||
// 再次检查是否正在下载
"1"!==data.isDownloading&&!0!==data.isRebuilding&&
// 检查popup是否打开
//            if (data.popupOpen === '1') {
//                console.log(`[DELAY_UPLOAD] popup打开中，取消上传`);
//                return;
//            }
// 获取用户信息
chrome.storage.local.get(["identify","sync_target","p"],function(data2){
// 检查 identify 值是否存在
data2.identify&&chrome.bookmarks.getTree(function(bookmarkTreeNodes){let bookmarks=JSON.stringify(bookmarkTreeNodes),browserType="chrome",headers=(void 0!==(browserType=void 0===data2.sync_target||""===data2.sync_target||null===data2.sync_target?data.defaultBrowser||"chrome":"0"===data2.sync_target?"safari":"chrome")&&""!==browserType&&null!==browserType||(browserType="chrome"),{"Content-Type":"application/json",identify:data2.identify,code:"1003",tag:browserType});
// 添加自动上传历史记录
HistoryManager.addHistory(`自动上传(${eventType})`,!0),chrome.storage.local.get(["BASE_URL"],function(result){
// 确保 BASE_URL 存在
result.BASE_URL||(result.BASE_URL="https://bk.ithuajiao.site");let uploadStartTime=Date.now();sendXhrRequest("POST",result.BASE_URL,headers,bookmarks).then(data=>{Date.now(),uploadStartTime;!data.success&&0<=data.message.indexOf("duplicate")?(
// 添加重复数据检测历史记录
HistoryManager.addHistory("手动上传检测到重复数据，重建本地书签",!1),
// 设置重建标志，防止删除时触发上传
chrome.storage.local.set({isRebuilding:!0},function(){
// 删除本地 重新拉取
deleteAll(function(){
// 清除重建标志
chrome.storage.local.remove("isRebuilding",function(){debouncedDownload("Chrome",!1,data2.identify,result.BASE_URL,1e3)})})})):(chrome.storage.local.set({isDownloading:"0"}),
// 显示上传成功的通知
showSyncSuccessNotification("upload"))}).catch(error=>{
// 确保在出错时也清除下载状态
chrome.storage.local.set({isDownloading:"0"})})})})})})},2500)}
// 防抖包装函数，用于download函数
function debouncedDownload(type,needShow,item,baseUrl,delay=3e3){
// 创建并返回一个Promise
// 清除之前的定时器
return downloadDebounceTimer&&clearTimeout(downloadDebounceTimer),new Promise((resolve,reject)=>{
// 设置新的定时器
downloadDebounceTimer=setTimeout(()=>{download(type,needShow,item,baseUrl).then(resolve).catch(reject)},delay)})}
// 显示同步成功通知（上传或下载）
function showSyncSuccessNotification(type){
// 获取同步通知配置
chrome.storage.local.get(["uploadNotification"],function(data){
// 如果未开启同步通知，则直接返回
data.uploadNotification&&(data="upload"===type?"书签已成功上传到云端！":"书签已成功下载到本地！",
// 方法1: 使用chrome.notifications API
chrome.notifications.create({type:"basic",iconUrl:chrome.runtime.getURL("icons/icon48.png"),title:"书签同步",message:new Date(Date.now()).toISOString()+data,priority:2,requireInteraction:!0},function(notificationId){
// 5秒后自动清除通知
setTimeout(()=>{chrome.notifications.clear(notificationId,function(wasCleared){})},1e4)}))})}
//=============could be deleted==============
function deleteAll(callback){Date.now();chrome.storage.local.remove("version"),chrome.bookmarks.getTree(function(bookmarkTreeNodes){let deletePromises=[];bookmarkTreeNodes.forEach(node=>{deletePromises.push(new Promise(resolve=>{deleteNode(node,resolve)}))}),Promise.all(deletePromises).then(()=>{Date.now();callback&&callback()}).catch(error=>{callback&&callback()})})}
// 执行上传操作的函数
async function performUpload(defaultBrowser){var uploadStartTime=Date.now();try{
// 检查全局同步锁，防止并发执行，添加超时机制
var lockResult=await new Promise(resolve=>{chrome.storage.local.get(["globalSyncLock"],function(result){resolve(result.globalSyncLock)})});
// 检查锁是否超时（超过5分钟）
if(lockResult){let lockTime=parseInt(lockResult);if(isNaN(lockTime)||!(3e5<Date.now()-lockTime))return;await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}
// 设置全局同步锁，存储当前时间戳
let lockTime=Date.now().toString();await new Promise(resolve=>{chrome.storage.local.set({globalSyncLock:lockTime},function(){resolve()})}),
// 添加手动上传历史记录
HistoryManager.addHistory("手动上传",!1);
// 获取用户标识和基础URL
var result=await new Promise(resolve=>{chrome.storage.local.get(["identify","sync_target","BASE_URL"],function(data){resolve(data)})});if(result.identify){
// 获取书签数据
var bookmarkTreeNodes=await new Promise(resolve=>{chrome.bookmarks.getTree(function(nodes){resolve(nodes)})}),bookmarks=JSON.stringify(bookmarkTreeNodes);
// 决定上传的浏览器类型
let browserType="chrome";void 0!==(browserType=void 0===result.sync_target||""===result.sync_target||null===result.sync_target?defaultBrowser||"chrome":"0"===result.sync_target?"safari":"chrome")&&""!==browserType&&null!==browserType||(browserType="chrome");
// 获取压缩后的数据和头部信息
var compressedData=CompressionUtils.getCompressedData(bookmarks),headers={"Content-Type":"application/json",identify:result.identify,code:"1003",tag:browserType,...compressedData.headers},responseText=(Date.now(),await sendXhrRequest("POST",result.BASE_URL,headers,compressedData.data));Date.now();let resultJson;try{
// 检查responseText是否已经是解析后的对象
resultJson="string"==typeof responseText?JSON.parse(responseText):responseText}catch(parseError){resultJson={success:!1,message:"响应不是有效的JSON格式"}}if(resultJson.success){Date.now();
// 记录上传时间
let now=Date.now();chrome.storage.local.set({lastUploadTime:now},function(){}),
// 显示上传成功的通知
showSyncSuccessNotification("upload")}}}catch(error){}finally{
// 释放全局同步锁
await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}}
// 执行下载操作的函数
async function performDownload(type,needShow){Date.now();
// 通知popup显示0%进度
safeSendMessage({action:"syncProgressUpdate",current:0,total:100,// 初始值，后续会被更新
percentage:0});try{
// 检查全局同步锁，防止并发执行，添加超时机制
var lockResult=await new Promise(resolve=>{chrome.storage.local.get(["globalSyncLock"],function(result){resolve(result.globalSyncLock)})});
// 检查锁是否超时（超过5分钟）
if(lockResult){let lockTime=parseInt(lockResult);if(isNaN(lockTime)||!(3e5<Date.now()-lockTime))return;await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}
// 设置全局同步锁，存储当前时间戳
let lockTime=Date.now().toString(),result=(await new Promise(resolve=>{chrome.storage.local.set({globalSyncLock:lockTime},function(){resolve()})}),
// 添加手动下载历史记录
HistoryManager.addHistory("手动下载",!1),await new Promise(resolve=>{chrome.storage.local.get(["identify","BASE_URL","version"],function(data){resolve(data)})}));
// 直接使用从存储中获取的 identify 值，而不是依赖全局变量
if(result.identify){result.BASE_URL||(result.BASE_URL="http://127.0.0.1:9999");var header={code:"1006",identify:result.identify},checkRes=(Date.now(),await sendXhrRequest("POST",result.BASE_URL,header,null));Date.now();let jsonRes;try{jsonRes="string"==typeof checkRes?JSON.parse(checkRes):checkRes}catch(parseError){
// 创建一个默认的响应对象，避免后续代码出错
jsonRes={success:!1,message:"响应不是有效的JSON格式",message:{hasSafari:!1,hasChrome:!1},source:{hasSafari:!1,hasChrome:!1}}}if(jsonRes.source.hasSafari||jsonRes.source.hasChrome){
// 使用parseInt()将字符串转换为整数
var versionString=result.version||"0";let versionInt=parseInt(versionString,10);isNaN(versionInt)&&(versionInt=0),jsonRes.version<=versionInt?
// 发送100%进度更新
safeSendMessage({action:"syncProgressUpdate",current:0,total:0,percentage:100}):(type="Chrome",
// 设置下载状态
chrome.storage.local.set({isDownloading:"1"},function(){
// 直接传递 identify 值，而不是依赖全局变量
importBookmarksFromURL(result.BASE_URL,result.identify,type)}))}}}catch(error){
// 确保在出错时也清除下载状态
chrome.storage.local.set({isDownloading:"0"})}finally{
// 释放全局同步锁
await new Promise(resolve=>{chrome.storage.local.remove("globalSyncLock",function(){resolve()})})}}
// 检查本地重复书签的函数
function checkLocalDuplicateBookmarks(){Date.now();chrome.bookmarks.getTree(function(bookmarkTreeNodes){if(bookmarkTreeNodes&&0!==bookmarkTreeNodes.length){let foundBookmarksBar=!1;
// 只检查书签栏中的书签（与服务端逻辑保持一致）
for(var rootNode of bookmarkTreeNodes)if(rootNode.children&&Array.isArray(rootNode.children)){for(var child of rootNode.children)
// 只处理书签栏（index为0的节点）
if(("Bookmarks Bar"===child.title||"书签栏"===child.title)&&"1"===child.id){foundBookmarksBar=!0,
// 检查书签栏中的重复书签（同一父节点下）
checkDuplicateInSameParent(child.children,"书签栏");break}if(foundBookmarksBar)break}foundBookmarksBar;Date.now()}})}
// 检查同一父节点下的重复书签（与服务端逻辑保持一致）
function checkDuplicateInSameParent(bookmarks,location){if(bookmarks&&Array.isArray(bookmarks)){var bookmark,titleSet=new Set,titleUrlSet=new Set;let duplicateCount=0,duplicateTitleCount=0;for(bookmark of bookmarks){var duplicateMessage,title=bookmark.title,url=bookmark.url;
// 跳过文件夹（没有URL的书签）
url&&(titleUrlSet.has(url=title+"|"+url)?(
// 发现重复，添加到历史记录
duplicateCount++,duplicateMessage=`发现重复书签: "${title}" (${location})`,HistoryManager.addHistory(duplicateMessage,!0)):titleUrlSet.add(url),
// 检查标题是否重复（即使URL不同）
titleSet.has(title)?(
// 发现重复标题，添加到历史记录
duplicateTitleCount++,duplicateMessage=`发现重复书签标题: "${title}" (${location})`,HistoryManager.addHistory(duplicateMessage,!0)):titleSet.add(title));
// 检查标题和URL的组合是否重复（与服务端逻辑保持一致）
}}}
// 执行删除本地书签操作的函数
async function performDeleteLocalBookmarks(){try{
// 删除所有本地书签
await new Promise(resolve=>{chrome.storage.local.remove("version",function(){chrome.bookmarks.getTree(function(bookmarkTreeNodes){let deletePromises=[];bookmarkTreeNodes.forEach(node=>{deletePromises.push(new Promise(resolve=>{deleteBookmarkNode(node,resolve)}))}),Promise.all(deletePromises).then(()=>{resolve()}).catch(error=>{resolve()})})})})}catch(error){}}
// 递归删除书签节点
//=============could be deleted==============
function deleteBookmarkNode(node,callback){if(node.children){let deletePromises=[];node.children.forEach(folder=>{"1"!==folder.id&&"2"!==folder.id||folder.children&&folder.children.forEach(child=>{deletePromises.push(new Promise(resolve=>{try{chrome.storage.local.set({isDownloading:"1"},function(){chrome.bookmarks.removeTree(child.id,()=>{resolve()})})}catch(e){resolve()}}))})}),Promise.all(deletePromises).then(()=>{callback&&callback()}).catch(error=>{callback&&callback()})}else callback&&callback()}chrome.storage.onChanged.addListener(function(changes,namespace){"local"===namespace&&changes.autoSync&&(namespace=changes.autoSync.oldValue,changes=changes.autoSync.newValue,
// 如果从手动（true，复选框勾选）切换到自动（false，复选框未勾选），建立 WebSocket 连接
!0===namespace&&!1===changes?chrome.storage.local.get(["identify","BASE_URL"],function(result){result.identify&&result.BASE_URL&&connectWebSocket("autoSync_switch_to_auto")}):!1===namespace&&!0===changes&&closeWebSocket())});