/**
 * 恢复界面引导配置
 * 使用 Driver.js 库实现恢复界面的引导流程
 */
// 开发模式开关：true = 每次打开恢复界面都显示引导，false = 仅第一次显示引导
let RECOVER_GUIDE_DEV_MODE=!1,isRecoverGuideActive=!1,recoverGuideSteps=[{element:'button[lay-on="forever_save"]',popover:{title:I18N.getMessage("recover_guide_title"),description:I18N.getMessage("recover_guide_description"),side:"top",align:"center"}}],recoverDriverInstance=null,recoverStepCompleted=[!1],recoverButtonClickListeners={},isRecoverMovingNext=!1,recoverMoveNextCallCount=0,recoverPopupObserver=null;
// 引导状态标记：true = 正在引导中，false = 未在引导
/**

 * 创建恢复引导样式（在引导开始前调用，避免闪动）

 */
function createRecoverGuideStyles(){var style;document.getElementById("recover-guide-animation-style")||((style=document.createElement("style")).id="recover-guide-animation-style",style.textContent=`

        @keyframes recoverPulse {

            0% { transform: scale(1); }

            50% { transform: scale(1.15); }

            100% { transform: scale(1); }

        }

        @keyframes recoverGlow {

            0% { box-shadow: 0 0 10px 3px rgba(255, 152, 0, 0.7); }

            50% { box-shadow: 0 0 30px 15px rgba(255, 152, 0, 0.9); }

            100% { box-shadow: 0 0 10px 3px rgba(255, 152, 0, 0.7); }

        }

        .recover-button-pulse {

            animation: recoverPulse 1s infinite !important;

        }

        .recover-button-highlight {

            animation: recoverGlow 1.5s infinite !important;

            border: 3px solid #ff9800 !important;

        }

        .guide-popover {

            z-index: 999998 !important;

            max-width: 180px !important;

            min-width: 150px !important;

        }

        .guide-popover .driver-popover-content {

            padding: 6px !important;

            border-radius: 30px !important;

            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;

            box-shadow: 0 4px 15px rgba(0,0,0,0.3) !important;

        }

        .guide-popover .driver-popover-title {

            color: white !important;

            font-weight: bold !important;

            font-size: 12px !important;

            padding: 4px 8px !important;

            margin: 0 0 4px 0 !important;

            border-bottom: 1px dashed rgba(255,255,255,0.3) !important;

            text-align: center !important;

        }

        .guide-popover .driver-popover-description {

            font-size: 11px !important;

            line-height: 1.3 !important;

            margin-bottom: 4px !important;

            color: white !important;

            text-align: center !important;

        }

        .guide-popover .driver-popover-footer {

            margin-top: 4px !important;

            padding-top: 4px !important;

            border-top: 1px dashed rgba(255,255,255,0.2) !important;

            display: flex !important;

            justify-content: space-between !important;

            gap: 6px !important;

        }

        .guide-popover .driver-popover-footer button {

                        font-weight: normal !important;

                        padding: 3px 8px !important;

                        border-radius: 4px !important;

                        font-size: 10px !important;

                        flex: 0 1 auto !important;

                        min-width: 40px !important;

                        border: 1px solid rgba(255,255,255,0.3) !important;

                    }

                    .guide-popover .driver-popover-footer button.driver-prev-btn {

                        background: rgba(255,255,255,0.15) !important;

                        color: white !important;

                    }

                    .guide-popover .driver-popover-footer button.driver-next-btn {

                        background: rgba(255, 152, 0, 0.7) !important;

                        color: white !important;

                        opacity: 0.5 !important;

                        cursor: not-allowed !important;

                    }

                    .guide-popover .driver-popover-footer button.driver-next-btn.active {

                                    background: rgba(255, 152, 0, 0.9) !important;

                                    opacity: 1 !important;

                                    cursor: pointer !important;

                                }

                            .guide-popover .driver-popover-arrow {

                                display: none !important;

                            }

    `,document.head.appendChild(style))}
/**

 * 添加按钮动画效果（放大缩小）

 */function addRecoverButtonAnimation(element){element&&(
// 添加动画样式
element.style.transition="transform 0.5s ease-in-out",element.style.animation="recoverPulse 1s infinite",element.classList.add("recover-button-pulse","recover-button-highlight"))}
/**
 * 移除按钮动画效果
 */function removeRecoverButtonAnimation(element){element&&(element.classList.remove("recover-button-pulse","recover-button-highlight"),element.style.animation="",element.style.transition="")}
/**
 * 为按钮添加点击监听器
 */function setupRecoverButtonClickListener(stepIndex,selector){let button=document.querySelector(selector);if(button&&!recoverButtonClickListeners[stepIndex])
// 如果已经为这个步骤添加了监听器，直接返回
{let clickHandler=e=>{
// 检查是否在引导过程中
isRecoverGuideActive&&recoverDriverInstance&&((recoverDriverInstance.getCurrentStepIndex?recoverDriverInstance.getCurrentStepIndex():0)!==stepIndex||recoverStepCompleted[stepIndex]||(
// 标记步骤完成
recoverStepCompleted[stepIndex]=!0,
// 移除动画
removeRecoverButtonAnimation(button),
// 移除点击监听器
button.removeEventListener("click",clickHandler),delete recoverButtonClickListeners[stepIndex],endRecoverGuide()));
// 检查当前步骤
};return button.addEventListener("click",clickHandler),
// 存储监听器引用
recoverButtonClickListeners[stepIndex]={button:button,handler:clickHandler},{button:button,clickHandler:clickHandler}}}
/**
 * 创建弹窗监听器
 */function createRecoverPopupObserver(){recoverPopupObserver||
// 开始监听 DOM 变化
(recoverPopupObserver=new MutationObserver(mutations=>{mutations.forEach(mutation=>{mutation.addedNodes.forEach(node=>{
// 检查是否是弹窗元素
1===node.nodeType&&node.classList&&node.classList.contains("layui-layer")&&
// 立即结束引导
endRecoverGuide()})})})).observe(document.body,{childList:!0,subtree:!0})}
/**
 * 结束引导
 */function endRecoverGuide(){
// 销毁引导实例
if(
// 立即停止弹窗监听器，防止重复触发
recoverPopupObserver&&(recoverPopupObserver.disconnect(),recoverPopupObserver=null),recoverDriverInstance){try{recoverDriverInstance.destroy()}catch(e){}recoverDriverInstance=null}
// 停止监听
recoverPopupObserver&&(recoverPopupObserver.disconnect(),recoverPopupObserver=null),
// 清理所有动画
recoverGuideSteps.forEach((step,index)=>{step=document.querySelector(step.element);step&&removeRecoverButtonAnimation(step)}),Object.keys(recoverButtonClickListeners).forEach(stepIndex=>{stepIndex=recoverButtonClickListeners[stepIndex];stepIndex.button&&stepIndex.handler&&stepIndex.button.removeEventListener("click",stepIndex.handler)}),recoverButtonClickListeners={};
// 移除 Driver.js 的遮罩层和弹窗（如果有残留）
var driverOverlay=document.querySelector(".driver-overlay"),driverOverlay=(driverOverlay&&driverOverlay.remove(),document.querySelector(".driver-popover"));driverOverlay&&driverOverlay.remove(),document.querySelectorAll(".driver-active-element").forEach(el=>{el.classList.remove("driver-active-element")}),
// 标记引导结束
isRecoverGuideActive=!1,
// 仅在非开发模式下标记用户已完成引导
RECOVER_GUIDE_DEV_MODE||localStorage.setItem("recoverGuideCompleted","true");
// 移除所有 driver-active-element 类
}
/**
 * 启动恢复界面引导
 */function startRecoverGuide(){
// 检查是否已经在引导中
var driverFn,recoverGuideCompleted;
// 获取 driver 函数
// 先创建引导样式，避免闪动
createRecoverGuideStyles(),isRecoverGuideActive||"function"==typeof(driverFn=window.driver&&window.driver.driver||window.driver)&&(recoverGuideCompleted=localStorage.getItem("recoverGuideCompleted"),RECOVER_GUIDE_DEV_MODE||"true"!==recoverGuideCompleted)&&(recoverGuideCompleted=document.querySelector("#recover_row"))&&recoverGuideCompleted.querySelector('button[lay-on="forever_save"]')&&(
// 标记引导开始
isRecoverGuideActive=!0,
// 重置步骤完成状态
recoverStepCompleted=[!1],
// 重置按钮点击监听器
recoverButtonClickListeners={},
// 重置 moveNext 调用计数
recoverMoveNextCallCount=0,
// 创建弹窗监听器
createRecoverPopupObserver(),(recoverDriverInstance=driverFn({showProgress:!1,steps:recoverGuideSteps,nextBtnText:I18N.getMessage("guide_next_btn_click"),prevBtnText:I18N.getMessage("guide_prev_btn"),doneBtnText:I18N.getMessage("guide_done_btn"),closeBtnText:I18N.getMessage("guide_close_btn"),progressText:"",overlayColor:"rgba(0, 0, 0, 0.75)",popoverClass:"guide-popover",popoverOffset:10,animate:!0,allowClose:!1,disableActiveInteraction:!1,overlayClickNext:!1,showPrevButton:!1,buttonsConfig:{prev:{text:"",action:()=>{}}},
// 禁用默认的下一步按钮逻辑
onNextClick:()=>{var currentStepIndex=recoverDriverInstance.getCurrentStepIndex?recoverDriverInstance.getCurrentStepIndex():0;return!!recoverStepCompleted[currentStepIndex]},onHighlightStarted:element=>{},onHighlighted:element=>{let currentStepIndex=recoverDriverInstance.getCurrentStepIndex?recoverDriverInstance.getCurrentStepIndex():0;
// 为当前步骤的按钮添加动画
var button;
// 更新下一步按钮的状态
setTimeout(()=>{var nextBtn=document.querySelector(".driver-popover-footer .driver-next-btn");nextBtn&&(recoverStepCompleted[currentStepIndex]?(nextBtn.classList.add("active"),nextBtn.textContent=I18N.getMessage("recover_guide_next_btn_completed")):(nextBtn.classList.remove("active"),nextBtn.textContent=I18N.getMessage("guide_next_btn_click")))},100),recoverGuideSteps[currentStepIndex]&&(button=document.querySelector(recoverGuideSteps[currentStepIndex].element))&&!recoverStepCompleted[currentStepIndex]&&(addRecoverButtonAnimation(button),
// 只有当该步骤还没有监听器时，才设置按钮点击监听
recoverButtonClickListeners[currentStepIndex]||setupRecoverButtonClickListener(currentStepIndex,recoverGuideSteps[currentStepIndex].element))},onDeselected:element=>{
// 清理上一个步骤的动画
element&&removeRecoverButtonAnimation(element);recoverDriverInstance.getCurrentStepIndex&&recoverDriverInstance.getCurrentStepIndex()},onDestroyed:()=>{
// 清理所有动画
recoverGuideSteps.forEach((step,index)=>{step=document.querySelector(step.element);step&&removeRecoverButtonAnimation(step)}),Object.keys(recoverButtonClickListeners).forEach(stepIndex=>{stepIndex=recoverButtonClickListeners[stepIndex];stepIndex.button&&stepIndex.handler&&stepIndex.button.removeEventListener("click",stepIndex.handler)}),recoverButtonClickListeners={},
// 停止监听
recoverPopupObserver&&(recoverPopupObserver.disconnect(),recoverPopupObserver=null),
// 标记引导结束
isRecoverGuideActive=!1,
// 仅在非开发模式下标记用户已完成引导
RECOVER_GUIDE_DEV_MODE||localStorage.setItem("recoverGuideCompleted","true")}})).drive())}
/**
 * 手动触发恢复界面引导（用于测试或重新引导）
 */function restartRecoverGuide(){localStorage.removeItem("recoverGuideCompleted"),startRecoverGuide()}