// Driver.js 包装文件
// 修复原始 driver.js 文件的导出问题

// 加载原始的 driver.js
(function() {
    // 保存原始的 window 对象
    var originalWindow = window;
    
    // 修复原始文件中的 this.driver.js 问题
    // 将 this.driver.js 改为 this.driver
    var script = document.createElement('script');
    script.src = chrome.runtime.getURL('driver.js');
    script.onload = function() {
        // 修复导出
        if (window.driver && window.driver.js) {
            window.driver = window.driver.js;
        }
    };
    document.head.appendChild(script);
})();