let input=document.querySelector(".search-input"),resultsContainer=document.querySelector(".results-container"),selectedIndex=-1,bookmarks=[],searchHistory=[],historyIndex=-1,isNavigatingResults=!1,searchResults=[];function extractBookmarks(bookmarkNode,path=[]){let bookmarks=[];return bookmarkNode.children&&bookmarkNode.children.forEach(child=>{var currentPath=[...path];child.title&&!child.url&&currentPath.push(child.title),child.url&&bookmarks.push({...child,folderPath:currentPath}),child.children&&(bookmarks=bookmarks.concat(extractBookmarks(child,currentPath)))}),bookmarks}
// 搜索函数
function search(query){if(query){
// 搜索书签
let bookmarkResults=bookmarks.filter(bookmark=>{var bookmark=bookmark.title.toLowerCase(),pinyinInitials=(query=query.toLowerCase(),bookmark.split("").map(char=>(/[a-zA-Z]/.test(char)?char:pinyinPro.pinyin(char,{pattern:"first",toneType:"none"})).toLowerCase()).join("")),fullPinyin=pinyinPro.pinyin(bookmark,{toneType:"none"}).toLowerCase();return bookmark.includes(query)||fullPinyin.includes(query)||pinyinInitials.includes(query)}).map(bookmark=>({...bookmark,type:"bookmark"}));
// 搜索历史记录
searchHistoryAPI(query).then(historyResults=>{
// 合并结果并去重
historyResults=mergeAndDedupeResults(bookmarkResults,historyResults);
// 排序：历史记录优先，然后按时间排序
// 限制最多20条结果
displayResults(searchResults=historyResults.sort((a,b)=>
// 历史记录优先
"history"===a.type&&"history"!==b.type?-1:"history"!==a.type&&"history"===b.type?1:(b.lastVisitTime||b.dateAdded)-(a.lastVisitTime||a.dateAdded)).slice(0,20))}).catch(error=>{
// 如果历史记录搜索失败，只显示书签结果
displayResults(searchResults=bookmarkResults.sort((a,b)=>(b.dateAdded||b.lastVisitTime)-(a.dateAdded||a.lastVisitTime)).slice(0,20))})}else resultsContainer.innerHTML="",adjustWindowHeight(0)}
// 合并并去重搜索结果
function mergeAndDedupeResults(bookmarkResults,historyResults){let urlMap=new Map,hostnameMap=new Map,finalResults=(// 用于同主机去重
// 优先处理书签结果（因为书签可能更重要）
bookmarkResults.forEach(bookmark=>{urlMap.set(bookmark.url,bookmark);
// 记录主机名映射
try{var hostname=new URL(bookmark.url).hostname;hostnameMap.has(hostname)||hostnameMap.set(hostname,bookmark)}catch(e){
// URL解析失败，直接添加到结果
hostnameMap.set(bookmark.url,bookmark)}}),
// 处理历史记录结果
historyResults.forEach(history=>{
// 检查同主机去重
try{var hostname=new URL(history.url).hostname;hostnameMap.has(hostname)?
// 如果已有该主机名的记录，只在没有相同URL时添加
urlMap.has(history.url)||urlMap.set(history.url,{...history,type:"history"}):(
// 如果该主机名还没有记录，添加历史记录
hostnameMap.set(hostname,{...history,type:"history"}),urlMap.set(history.url,{...history,type:"history"}))}catch(e){
// URL解析失败，直接添加到结果
urlMap.has(history.url)||urlMap.set(history.url,{...history,type:"history"})}}),Array.from(hostnameMap.values()));
// 添加未被主机名映射包含的其他URL（不同主机名的URL）
return Array.from(urlMap.values()).forEach(item=>{try{var hostname=new URL(item.url).hostname;
// 如果这个主机名的记录已经在最终结果中，跳过
hostnameMap.has(hostname)&&hostnameMap.get(hostname).url===item.url||finalResults.push(item)}catch(e){
// URL解析失败，直接添加
finalResults.push(item)}}),finalResults}
// 搜索历史记录的函数
function searchHistoryAPI(query){return new Promise((resolve,reject)=>{
// 为了支持拼音首字母搜索，我们不直接使用query过滤，
// 而是获取更多历史记录然后在本地过滤
chrome.history.search({text:"",// 不直接使用query过滤，获取更多结果
maxResults:100,// 获取更多结果以增加匹配机会
startTime:0},historyItems=>{if(chrome.runtime.lastError)reject(chrome.runtime.lastError);else{
// 过滤掉没有标题或URL的结果，并支持拼音首字母搜索
historyItems=historyItems.filter(item=>{if(!item.title||!item.url)return!1;var title=item.title.toLowerCase(),url=item.url.toLowerCase(),pinyinInitials=(query=query.toLowerCase(),title.split("").map(char=>{if(/[a-zA-Z]/.test(char))return char.toLowerCase();
// 使用pinyinPro库获取汉字拼音首字母
try{return pinyinPro.pinyin(char,{pattern:"first",toneType:"none"}).toLowerCase()}catch(e){
// 如果转换失败，返回原字符
return char}}).join(""));
// 获取完整拼音（标题）
let fullPinyin="";try{fullPinyin=pinyinPro.pinyin(title,{toneType:"none"}).toLowerCase()}catch(e){
// 如果转换失败，保持为空字符串
}
// 处理URL中的中文字符
let urlPinyinInitials="",urlFullPinyin="";try{
// 尝试解码URL中的中文部分
var chineseChars=decodeURIComponent(item.url).match(/[\u4e00-\u9fa5]/g)||[];
// 提取URL中的非ASCII字符进行拼音转换
urlPinyinInitials=chineseChars.map(char=>{try{return pinyinPro.pinyin(char,{pattern:"first",toneType:"none"}).toLowerCase()}catch(e){return char}}).join(""),urlFullPinyin=chineseChars.map(char=>{try{return pinyinPro.pinyin(char,{toneType:"none"}).toLowerCase()}catch(e){return char}}).join("")}catch(e){
// URL解码失败，保持为空字符串
}return title.includes(query)||url.includes(query)||fullPinyin.includes(query)||pinyinInitials.includes(query)||urlPinyinInitials.includes(query)||urlFullPinyin.includes(query)}).map(item=>({...item,type:"history"}));
// 按主机名去重，保留最近访问的记录
let hostnameMap=new Map,deduplicatedResults=[];historyItems.forEach(item=>{try{var index,hostname=new URL(item.url).hostname;if(hostnameMap.has(hostname)){
// 如果已存在同主机记录，比较访问时间，保留最近的
let existingItem=hostnameMap.get(hostname);item.lastVisitTime>existingItem.lastVisitTime&&(-1!==(index=deduplicatedResults.findIndex(i=>i.url===existingItem.url))&&(deduplicatedResults[index]=item),hostnameMap.set(hostname,item))}else hostnameMap.set(hostname,item),deduplicatedResults.push(item)}catch(e){
// URL解析失败，直接添加
deduplicatedResults.push(item)}}),
// 限制结果数量
resolve(deduplicatedResults.slice(0,20))}})})}
// 显示结果
function displayResults(results){resultsContainer.innerHTML="",selectedIndex=-1,results.forEach((result,index)=>{let div=document.createElement("div");// 'bookmark' 或 'history'
div.className="result-item",
// 存储URL和类型到DOM元素上，方便后续获取
div.dataset.url=result.url,div.dataset.type=result.type;
// try {
//     faviconUrl = `https://www.google.com/s2/favicons?domain=${encodeURIComponent(new URL(result.url).hostname)}`;
// } catch (error) {
var typeIndicator="history"===result.type?"🕒":"⭐";
// 构建文件夹路径显示
let folderPathDisplay="";"bookmark"===result.type&&result.folderPath&&0<result.folderPath.length&&(folderPathDisplay=`<span class="folder-path">${result.folderPath.join(" > ")} > </span>`),div.innerHTML=`
           <img class="favicon" src="icons/icon16.png" onerror="this.src='icons/icon16.png'"> 
            <div class="result-content">
                ${folderPathDisplay}
                <span class="result-title">${typeIndicator} ${result.title}</span>
            </div>
        `,div.addEventListener("click",()=>{handleResultSelection(div)}),resultsContainer.appendChild(div)}),adjustWindowHeight(results.length)}
// 调整窗口高度
function adjustWindowHeight(resultCount){resultCount=Math.min(resultCount,10);// 输入框区域高度
let finalHeight=Math.max(80+65*resultCount+100,150);chrome.windows.getCurrent(window=>{chrome.windows.update(window.id,{height:finalHeight})})}function loadSearchHistory(){var saved=localStorage.getItem("searchHistory");searchHistory=saved?JSON.parse(saved):[]}function saveSearchHistory(query){query&&!searchHistory.includes(query)&&(searchHistory.unshift(query),10<searchHistory.length&&searchHistory.pop(),localStorage.setItem("searchHistory",JSON.stringify(searchHistory)))}function updateSelection(items){items.forEach((item,index)=>{item.classList.toggle("selected",index===selectedIndex),index===selectedIndex&&item.scrollIntoView({block:"nearest"})})}// 存储搜索结果（书签+历史记录）
document.addEventListener("DOMContentLoaded",function(){
// Initialize i18n for text content
document.querySelectorAll("[data-i18n]").forEach(element=>{var key=element.getAttribute("data-i18n");element.textContent=I18N.getMessage(key,element.textContent)}),I18N.initializeAttributes()}),chrome.bookmarks.getTree(function(bookmarkTreeNodes){bookmarks=extractBookmarks(bookmarkTreeNodes[0])}),input.addEventListener("keydown",e=>{var selectedItem,items=resultsContainer.querySelectorAll(".result-item");switch(e.key){case"ArrowDown":e.preventDefault(),0<items.length?(isNavigatingResults=!0,selectedIndex=Math.min(selectedIndex+1,items.length-1),updateSelection(items)):isNavigatingResults||(-1===(historyIndex=Math.max(-1,historyIndex-1))?input.value="":input.value=searchHistory[historyIndex],search(input.value));break;case"ArrowUp":e.preventDefault(),isNavigatingResults&&0<items.length?(selectedIndex=Math.max(selectedIndex-1,0),updateSelection(items)):historyIndex<searchHistory.length-1&&(historyIndex++,input.value=searchHistory[historyIndex],search(input.value));break;case"Enter":input.value.trim()&&saveSearchHistory(input.value.trim()),0<items.length&&(selectedItem=-1===selectedIndex?items[0]:items[selectedIndex])&&handleBookmarkSelection(selectedItem);break;case"Escape":window.close()}});let debounceTimer=null;
/**
 * 在标签页列表中查找匹配主机名或IP+端口的标签页
 * @param {Array} tabs - 标签页列表
 * @param {string} hostname - 要匹配的主机名或IP
 * @param {string} port - 要匹配的端口
 * @param {string} pathname - 要匹配的路径
 * @returns {Object|null} 匹配的标签页或null
 */
function findMatchingTab(tabs,hostname,port){return tabs.find(tab=>{try{var tabUrl=new URL(tab.url);
// 检查是否为IP地址
// 对于IP地址，只需匹配主机名和端口，忽略路径和查询参数
return/^(\d{1,3}\.){3}\d{1,3}$/.test(hostname)&&port?tabUrl.hostname===hostname&&tabUrl.port===port:tabUrl.hostname===hostname}catch(e){return!1}})}
/**
 * 处理结果选择并打开
 * @param {Element} selectedItem - 选中的DOM元素
 */function handleResultSelection(selectedItem){
// 直接从DOM元素获取URL和类型
var targetUrl=selectedItem.dataset.url;// 'bookmark' 或 'history'
"history"===selectedItem.dataset.type?(
// 对于历史记录，直接打开URL
chrome.tabs.create({url:targetUrl}),window.close()):
// 对于书签，使用原有的逻辑
handleBookmarkSelection(selectedItem)}
/**
 * 处理书签选择并打开
 * @param {Element} selectedItem - 选中的DOM元素
 */function handleBookmarkSelection(selectedItem){
// 直接从DOM元素获取URL
let targetUrl=selectedItem.dataset.url,targetHostname,targetPort;
// 尝试获取URL的主机名和端口
try{var urlObj=new URL(targetUrl);targetHostname=urlObj.hostname,targetPort=urlObj.port,
// 查询所有标签页
chrome.tabs.query({},function(tabs){
// 打印所有标签页的URL信息，帮助调试
tabs.forEach(tab=>{try{new URL(tab.url)}catch(e){}});tabs=findMatchingTab(tabs,targetHostname,targetPort);tabs?
// 如果找到匹配的标签页，切换到该标签页
switchToTab(tabs):
// 如果没有找到匹配的标签页，打开新标签页
window.open(targetUrl,"_blank"),window.close()})}catch(error){
// URL解析错误，直接打开新标签页
window.open(targetUrl,"_blank"),window.close()}}
/**
 * 切换到指定的标签页
 * @param {Object} tab - 要切换到的标签页
 */function switchToTab(tab){chrome.tabs.update(tab.id,{active:!0}),chrome.windows.update(tab.windowId,{focused:!0})}input.addEventListener("input",()=>{isNavigatingResults=!1,historyIndex=-1,clearTimeout(debounceTimer),debounceTimer=setTimeout(()=>{search(input.value)},150)}),loadSearchHistory(),input.focus();