// 标签页管理器
class TabManager{constructor(){
// 日志开关，默认关闭
this.logEnabled=!1,this.log("创建TabManager实例"),
// 存储标签页打开时间戳
this.tabTimer={},
// 存储标签页最后活跃时间
this.lastActiveTime={},
// 用户配置
this.config={maxTabs:0,// 默认最大标签数，0表示不限制
timeLimit:0},
// 白名单URL
this.whitelist=["chrome://","chrome-extension://"],this.log("TabManager初始配置:",this.config),this.init()}
// 日志输出方法
log(){this.logEnabled}error(){this.logEnabled}
// 初始化
async init(){try{
// 从存储中读取用户配置
var result=await chrome.storage.local.get(["maxTabs","timeLimit","whitelist"]);this.log("读取到的配置:",result),void 0!==result.maxTabs&&(this.config.maxTabs=result.maxTabs),void 0!==result.timeLimit&&(this.config.timeLimit=result.timeLimit),result.whitelist&&(this.whitelist=result.whitelist),this.log("当前配置:",this.config)}catch(error){this.error("读取配置时出错:",error)}
// 监听标签页激活事件
chrome.tabs.onActivated.addListener(activeInfo=>{this.handleTabActivated(activeInfo)}),
// 监听标签页创建事件
chrome.tabs.onCreated.addListener(tab=>{this.handleTabCreated(tab)}),
// 监听标签页关闭事件
chrome.tabs.onRemoved.addListener((tabId,removeInfo)=>{this.handleTabRemoved(tabId)}),
// 监听标签页更新事件
chrome.tabs.onUpdated.addListener((tabId,changeInfo,tab)=>{this.handleTabUpdated(tabId,changeInfo,tab)});
// 初始化时获取所有现有标签页
try{(await chrome.tabs.query({})).forEach(tab=>{
// 初始化标签页时间戳
this.tabTimer[tab.id]||(this.tabTimer[tab.id]=Date.now()),this.lastActiveTime[tab.id]||(this.lastActiveTime[tab.id]=Date.now())})}catch(error){this.error("初始化标签页时出错:",error)}
// 启动定时检查机制
this.startPeriodicCheck()}
// 启动定时检查机制
startPeriodicCheck(){this.log("启动定时检查机制"),
// 每分钟检查一次
setInterval(()=>{this.checkAndCloseTimeoutTabs()},6e4),// 60000毫秒 = 1分钟
this.log("定时检查机制已启动，每分钟检查一次")}
// 检查并关闭超时标签页
async checkAndCloseTimeoutTabs(){try{this.log("开始检查标签页，当前配置:",this.config);
// 获取所有标签页
var tabs=await chrome.tabs.query({}),isOverMaxTabs=(this.log(`获取到 ${tabs.length} 个标签页`),0<this.config.maxTabs&&tabs.length>this.config.maxTabs);this.log(`标签页数量: ${tabs.length}, 最大限制: ${this.config.maxTabs}, 是否超过: `+isOverMaxTabs);
// 获取当前时间戳
let currentTime=Date.now();
// 如果超过最大标签页数，找出最早打开的可关闭标签页并关闭它
if(isOverMaxTabs){
// 过滤掉固定标签页和白名单URL
var closableTabs=tabs.filter(tab=>this.isClosable(tab));if(this.log("可关闭的标签页数量: "+closableTabs.length),0<closableTabs.length){
// 找出最早打开的标签页
let oldestTab=null,oldestTime=currentTime;for(var tab of closableTabs){var openTime=this.tabTimer[tab.id]||tab.windowId;this.log(`标签页 ${tab.id} 打开时间: `+new Date(openTime).toISOString()),openTime<oldestTime&&(oldestTime=openTime,oldestTab=tab)}if(oldestTab)try{await chrome.tabs.remove(oldestTab.id),this.log(`已关闭最早打开的标签页: ${oldestTab.url} (原因: 超过最大标签页数)`)}catch(error){this.error("关闭最早打开的标签页失败: "+error.message)}}}
// 检查超时的标签页 - 只关闭最早的且超过时间限制的标签页
var timeoutTabs=tabs.filter(tab=>{
// 检查标签页是否可关闭
var lastActiveTime;
// 获取标签页最后活跃时间，如果没有记录则使用打开时间
return!!this.isClosable(tab)&&(
// 检查是否超过时间限制 - 当timeLimit为0时不进行时间检查
lastActiveTime=this.lastActiveTime[tab.id]||this.tabTimer[tab.id]||tab.windowId,this.log(`标签页 ${tab.id} 最后活跃时间: `+new Date(lastActiveTime).toISOString()),lastActiveTime=(currentTime-lastActiveTime)/6e4,this.log(`标签页 ${tab.id} 未活跃时间: ${lastActiveTime} 分钟，限制: ${this.config.timeLimit} 分钟`),0<this.config.timeLimit)&&lastActiveTime>this.config.timeLimit});
// 如果有超时的标签页，只关闭最早的
if(0<timeoutTabs.length){let oldestTimeoutTab=null,oldestTime=currentTime;for(let tab of timeoutTabs){var lastActiveTime=this.lastActiveTime[tab.id]||this.tabTimer[tab.id]||tab.windowId;lastActiveTime<oldestTime&&(oldestTime=lastActiveTime,oldestTimeoutTab=tab)}if(oldestTimeoutTab)try{await chrome.tabs.remove(oldestTimeoutTab.id),this.log(`已关闭最早的超时标签页: ${oldestTimeoutTab.url} (原因: 超过时间限制)`)}catch(error){this.error("关闭最早的超时标签页失败: "+error.message)}}}catch(error){this.error("检查标签页时出错:",error)}}
// 处理标签页激活事件
handleTabActivated(activeInfo){try{this.log("标签页激活事件:",activeInfo);var tabId=activeInfo.tabId,timestamp=Date.now();
// 更新最后活跃时间
this.lastActiveTime[tabId]=timestamp,this.log(`更新标签页 ${tabId} 的活跃时间为: `+new Date(timestamp).toISOString()),
// 如果是新标签页，记录打开时间
this.tabTimer[tabId]||(this.tabTimer[tabId]=timestamp,this.log(`记录标签页 ${tabId} 的打开时间为: `+new Date(timestamp).toISOString())),
// 检查是否需要关闭标签页（任一条件满足时）
this.checkAndCloseTimeoutTabs()}catch(error){this.error("处理标签页激活事件时出错:",error)}}
// 处理标签页创建事件
handleTabCreated(tab){try{this.log("标签页创建事件:",tab);var timestamp=Date.now();
// 记录标签页打开时间
this.tabTimer[tab.id]=timestamp,this.log(`记录标签页 ${tab.id} 的打开时间为: `+new Date(timestamp).toISOString()),
// 初始化最后活跃时间为创建时间
this.lastActiveTime[tab.id]=timestamp,this.log(`记录标签页 ${tab.id} 的活跃时间为: `+new Date(timestamp).toISOString()),
// 检查是否需要关闭标签页（任一条件满足时）
this.checkAndCloseTimeoutTabs()}catch(error){this.error("处理标签页创建事件时出错:",error)}}
// 处理标签页关闭事件
handleTabRemoved(tabId){try{this.log(`标签页 ${tabId} 已关闭`),
// 清理已关闭标签页的数据
delete this.tabTimer[tabId],this.log(`已清理标签页 ${tabId} 的打开时间记录`),delete this.lastActiveTime[tabId],this.log(`已清理标签页 ${tabId} 的活跃时间记录`)}catch(error){this.error("处理标签页关闭事件时出错:",error)}}
// 处理标签页更新事件
handleTabUpdated(tabId,changeInfo,tab){try{
// 当标签页URL发生变化或页面加载完成时，重置活跃时间
var timestamp;this.log("标签页更新事件:",{tabId:tabId,changeInfo:changeInfo,url:tab.url}),!changeInfo.url&&"complete"!==changeInfo.status||(timestamp=Date.now(),this.lastActiveTime[tabId]=timestamp,this.log(`标签页 ${tabId} 更新，重置活跃时间为: `+new Date(timestamp).toISOString()),this.tabTimer[tabId])||(this.tabTimer[tabId]=timestamp,this.log(`记录标签页 ${tabId} 的打开时间为: `+new Date(timestamp).toISOString()))}catch(error){this.error("处理标签页更新事件时出错:",error)}}
// 强制执行标签页数量限制
async enforceTabLimit(){try{this.log("开始执行标签页数量限制检查，当前配置:",this.config);
// 获取所有标签页
var tabs=await chrome.tabs.query({});
// 当maxTabs为0时不检查数量限制
if(this.log(`获取到 ${tabs.length} 个标签页，限制: `+this.config.maxTabs),0===this.config.maxTabs||tabs.length<=this.config.maxTabs)this.log("标签页数量未超过限制，无需关闭");else{
// 过滤掉固定标签页和白名单URL
var closableTabs=tabs.filter(tab=>this.isClosable(tab));
// 如果没有可关闭的标签页，直接返回
if(this.log("可关闭的标签页数量: "+closableTabs.length),0===closableTabs.length)this.log("没有可关闭的标签页");else{
// 找出最早打开的标签页
let oldestTab=null,oldestTime=Date.now();for(var tab of closableTabs){var lastActiveTime=this.lastActiveTime[tab.id]||this.tabTimer[tab.id]||tab.windowId;this.log(`标签页 ${tab.id} 最后活跃时间: `+new Date(lastActiveTime).toISOString()),lastActiveTime<oldestTime&&(oldestTime=lastActiveTime,oldestTab=tab)}
// 关闭最早活跃的标签页
if(oldestTab)try{await chrome.tabs.remove(oldestTab.id),this.log(`已关闭最早活跃的标签页: ${oldestTab.url} (原因: 超过最大标签页数)`)}catch(error){this.error("关闭最早打开的标签页失败: "+error.message)}}}}catch(error){this.error("执行标签页数量限制时出错:",error)}}
// 检查标签页是否可关闭
isClosable(tab){try{
// 检查是否为固定标签页
if(this.log(`检查标签页 ${tab.id} 是否可关闭:`,tab),tab.pinned)return this.log(`标签页 ${tab.id} 是固定标签页，不可关闭`),!1;
// 检查是否在白名单中
for(var pattern of this.whitelist)if(tab.url.startsWith(pattern))return this.log(`标签页 ${tab.id} 在白名单中，不可关闭`),!1;return this.log(`标签页 ${tab.id} 可关闭`),!0}catch(error){return this.error("检查标签页是否可关闭时出错:",error),!1}}
// 更新用户配置
async updateConfig(newConfig){try{this.log("更新配置:",newConfig),
// 更新配置
void 0!==newConfig.maxTabs&&(this.config.maxTabs=newConfig.maxTabs),void 0!==newConfig.timeLimit&&(this.config.timeLimit=newConfig.timeLimit),void 0!==newConfig.whitelist&&(this.whitelist=newConfig.whitelist),this.log("更新后的配置:",this.config),
// 保存到存储
await chrome.storage.local.set({maxTabs:this.config.maxTabs,timeLimit:this.config.timeLimit,whitelist:this.whitelist}),this.log("配置已保存到存储"),
// 更新配置后检查标签页限制
this.enforceTabLimit()}catch(error){this.error("更新配置时出错:",error)}}
// 获取当前配置
getConfig(){return{...this.config,whitelist:[...this.whitelist]}}}
// 创建标签页管理器实例
let tabManager=new TabManager;
// 仅在非Service Worker环境中初始化UI相关代码
"undefined"!=typeof window?(
// 导出供其他模块使用
window.tabManager=tabManager,
// 页面加载完成后初始化标签页管理器
document.addEventListener("DOMContentLoaded",function(){
// 初始化标签页管理器
tabManager.init();
// 获取配置元素
let maxTabsInput=document.getElementById("maxTabs"),timeLimitInput=document.getElementById("timeLimit");
// 如果配置元素存在，则绑定事件
maxTabsInput&&timeLimitInput&&(
// 从存储中读取配置并设置到输入框
chrome.storage.local.get(["maxTabs","timeLimit"],function(result){void 0!==result.maxTabs&&(maxTabsInput.value=result.maxTabs),void 0!==result.timeLimit&&(timeLimitInput.value=result.timeLimit)}),
// 监听输入框变化并更新配置
maxTabsInput.addEventListener("change",function(){var maxTabs=parseInt(this.value);!isNaN(maxTabs)&&0<=maxTabs&&tabManager.updateConfig({maxTabs:maxTabs})}),timeLimitInput.addEventListener("change",function(){var timeLimit=parseInt(this.value);!isNaN(timeLimit)&&0<=timeLimit&&tabManager.updateConfig({timeLimit:timeLimit})}))})):
// 在Service Worker中直接初始化
tabManager.init();