/**
 * 新手引导配置
 * 使用 Driver.js 库实现四步引导流程
 */
// 开发模式开关：true = 每次登录都显示引导，false = 仅第一次显示引导
let GUIDE_DEV_MODE=!1,isGuideActive=!1,guideSteps=[{element:'button[lay-on="exportLocal"]',popover:{title:I18N.getMessage("guide_step1_title"),description:I18N.getMessage("guide_step1_description"),side:"top",align:"center"}},{element:'button[lay-on="upload"]',popover:{title:I18N.getMessage("guide_step2_title"),description:I18N.getMessage("guide_step2_description"),side:"top",align:"center"}},{element:'button[lay-on="download"]',popover:{title:I18N.getMessage("guide_step3_title"),description:I18N.getMessage("guide_step3_description"),side:"top",align:"center"}}],driverInstance=null,stepCompleted=[!1,!1,!1],animationIntervals=[],buttonClickListeners={},isMovingNext=!1,moveNextCallCount=0;
// 引导状态标记：true = 正在引导中，false = 未在引导
/**
 * 创建引导样式（在引导开始前调用，避免闪动）
 * 注意：样式已内联在 popup.html 中，此函数仅作为备用
 */
function createGuideStyles(){
// 检查是否已存在引导样式（可能在 popup.html 中已内联）
var style;
// 如果样式不存在，则创建（备用逻辑）
document.getElementById("guide-animation-style")||document.querySelector(".guide-popover")||((style=document.createElement("style")).id="guide-animation-style",style.textContent=`
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.08); }
            100% { transform: scale(1); }
        }
        @keyframes glow {
            0% { box-shadow: 0 0 12px 4px rgba(95, 184, 120, 0.6); }
            50% { box-shadow: 0 0 28px 12px rgba(95, 184, 120, 0.85); }
            100% { box-shadow: 0 0 12px 4px rgba(95, 184, 120, 0.6); }
        }
        .guide-button-pulse {
            animation: pulse 1.2s ease-in-out infinite !important;
        }
        .guide-button-highlight {
            animation: glow 2s ease-in-out infinite !important;
            border: 3px solid #5FB878 !important;
            border-radius: 8px !important;
        }
    `,document.head.appendChild(style))}
/**
 * 添加按钮动画效果（放大缩小）
 */function addButtonAnimation(element){element&&(
// 添加动画样式
element.style.transition="transform 0.5s ease-in-out",element.style.animation="pulse 1s infinite",element.classList.add("guide-button-pulse","guide-button-highlight"))}
/**
 * 移除按钮动画效果
 */function removeButtonAnimation(element){element&&(element.classList.remove("guide-button-pulse","guide-button-highlight"),element.style.animation="",element.style.transition="")}
/**
 * 为按钮添加点击监听器
 */function setupButtonClickListener(stepIndex,selector){let button=document.querySelector(selector);if(button&&!buttonClickListeners[stepIndex])
// 如果已经为这个步骤添加了监听器，直接返回
{let clickHandler=e=>{
// 检查是否在引导过程中
var nextBtn;
// 检查当前步骤
isGuideActive&&driverInstance&&(driverInstance.getCurrentStepIndex?driverInstance.getCurrentStepIndex():0)===stepIndex&&!stepCompleted[stepIndex]&&(
// 标记步骤完成
stepCompleted[stepIndex]=!0,
// 移除动画
removeButtonAnimation(button),
// 移除点击监听器
button.removeEventListener("click",clickHandler),delete buttonClickListeners[stepIndex],nextBtn=document.querySelector(".driver-popover-footer .driver-next-btn"))&&(nextBtn.classList.add("active"),nextBtn.textContent=I18N.getMessage("guide_next_btn_next"))};return button.addEventListener("click",clickHandler),
// 存储监听器引用
buttonClickListeners[stepIndex]={button:button,handler:clickHandler},{button:button,clickHandler:clickHandler}}}
/**
 * 启动新手引导
 */function startGuide(){
// 先创建引导样式，避免闪动
createGuideStyles();
// 获取 driver 函数
// driver.js 导出的是 Module 对象，真正的 driver 函数在 window.driver.driver 中
var driverFn=window.driver&&window.driver.driver||window.driver;if("function"==typeof driverFn){
// 标记引导开始
isGuideActive=!0,
// 重置步骤完成状态
stepCompleted=[!1,!1,!1],
// 重置按钮点击监听器
buttonClickListeners={},
// 重置 moveNext 调用计数
moveNextCallCount=0;
// 添加设置标签点击监听
let settingTab=document.querySelector('li[lay-id="setting"]'),settingTabClickHandler=()=>{
// 检查当前是否在第四步引导（设置标签）
var currentStepIndex=driverInstance&&driverInstance.getCurrentStepIndex?driverInstance.getCurrentStepIndex():-1;driverInstance&&driverInstance.isActivated&&3===currentStepIndex&&setTimeout(()=>{driverInstance&&"function"==typeof driverInstance.moveNext&&driverInstance.moveNext()},300)},recoverTab=document.querySelector('li[lay-id="recover"]'),recoverTabClickHandler=()=>{
// 检查当前是否在第五步引导（历史标签）
var currentStepIndex=driverInstance&&driverInstance.getCurrentStepIndex?driverInstance.getCurrentStepIndex():-1;driverInstance&&driverInstance.isActivated&&4===currentStepIndex&&setTimeout(()=>{driverInstance&&"function"==typeof driverInstance.moveNext&&driverInstance.moveNext()},300)};settingTab&&settingTab.addEventListener("click",settingTabClickHandler),recoverTab&&recoverTab.addEventListener("click",recoverTabClickHandler),(driverInstance=driverFn({showProgress:!0,steps:guideSteps,nextBtnText:I18N.getMessage("guide_next_btn_click"),prevBtnText:I18N.getMessage("guide_prev_btn"),doneBtnText:I18N.getMessage("guide_done_btn"),closeBtnText:I18N.getMessage("guide_close_btn"),progressText:I18N.getMessage("guide_progress_text"),overlayColor:"rgba(0, 0, 0, 0.75)",popoverClass:"guide-popover",popoverOffset:10,animate:!0,allowClose:!1,disableActiveInteraction:!1,overlayClickNext:!1,showPrevButton:!1,buttonsConfig:{prev:{text:"",action:()=>{}}},
// 禁用默认的下一步按钮逻辑
onNextClick:()=>{var currentStepIndex=driverInstance.getCurrentStepIndex?driverInstance.getCurrentStepIndex():0;return!!stepCompleted[currentStepIndex]},onHighlightStarted:element=>{},onHighlighted:element=>{
// 通过高亮元素匹配步骤索引
let currentStepIndex=-1;if(element)for(let i=0;i<guideSteps.length;i++){var stepButton=document.querySelector(guideSteps[i].element);if(stepButton&&element===stepButton){currentStepIndex=i;break}}
// 如果通过元素匹配失败，尝试使用 getCurrentStepIndex
// 为当前步骤的按钮添加动画
var button;-1===currentStepIndex&&(currentStepIndex=driverInstance.getCurrentStepIndex?driverInstance.getCurrentStepIndex():0),
// 动态调整引导框位置
setTimeout(()=>{var elementRect,popover=document.querySelector(".guide-popover");popover&&element&&(elementRect=element.getBoundingClientRect(),popover.getBoundingClientRect(),window.innerHeight,elementRect.top)},100),
// 更新下一步按钮的状态
setTimeout(()=>{var nextBtn=document.querySelector(".driver-popover-footer .driver-next-btn");nextBtn&&(stepCompleted[currentStepIndex]?(nextBtn.classList.add("active"),nextBtn.textContent=I18N.getMessage("guide_next_btn_next")):(nextBtn.classList.remove("active"),nextBtn.textContent=I18N.getMessage("guide_next_btn_click")))},100),guideSteps[currentStepIndex]&&(button=document.querySelector(guideSteps[currentStepIndex].element))&&!stepCompleted[currentStepIndex]&&(addButtonAnimation(button),
// 只有当该步骤还没有监听器时，才设置按钮点击监听
buttonClickListeners[currentStepIndex]||setupButtonClickListener(currentStepIndex,guideSteps[currentStepIndex].element))},onDeselected:element=>{
// 清理上一个步骤的动画
element&&removeButtonAnimation(element);driverInstance.getCurrentStepIndex&&driverInstance.getCurrentStepIndex()},onDestroyed:()=>{
// 清理所有动画
guideSteps.forEach((step,index)=>{step=document.querySelector(step.element);step&&removeButtonAnimation(step)}),Object.keys(buttonClickListeners).forEach(stepIndex=>{stepIndex=buttonClickListeners[stepIndex];stepIndex.button&&stepIndex.handler&&stepIndex.button.removeEventListener("click",stepIndex.handler)}),buttonClickListeners={},
// 移除事件监听
settingTab&&settingTab.removeEventListener("click",settingTabClickHandler),recoverTab&&recoverTab.removeEventListener("click",recoverTabClickHandler),
// 标记引导结束
isGuideActive=!1,
// 仅在非开发模式下标记用户已完成引导
GUIDE_DEV_MODE||localStorage.setItem("guideCompleted","true")}})).drive()}}
/**
 * 手动触发新手引导（用于设置页面的"重新开始引导"按钮）
 */function restartGuide(){localStorage.removeItem("guideCompleted"),startGuide()}